/*
 * Decompiled with CFR 0.152.
 */
package com.ultreon.libs.collections.v0.list;

import com.ultreon.libs.collections.v0.exceptions.OutOfRangeException;
import com.ultreon.libs.collections.v0.exceptions.ValueExistsException;
import com.ultreon.libs.collections.v0.util.ArrayUtils;
import com.ultreon.libs.collections.v0.util.Range;
import com.ultreon.libs.functions.v0.misc.Applier;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public class SizedList<T> {
    List<Double> sizes = new CopyOnWriteArrayList<Double>();
    final List<T> values = new CopyOnWriteArrayList<T>();
    Double totalSize = 0.0;

    public int add(double size, T value) {
        if (this.values.contains(value)) {
            throw new ValueExistsException();
        }
        this.sizes.add(size);
        this.values.add(value);
        SizedList sizedList = this;
        sizedList.totalSize = sizedList.totalSize + size;
        return this.sizes.lastIndexOf(size);
    }

    public void clear() {
        this.sizes.clear();
        this.values.clear();
        this.totalSize = 0.0;
    }

    public int insert(int index, double size, T value) {
        this.sizes.add(index, size);
        this.values.add(index, value);
        SizedList sizedList = this;
        sizedList.totalSize = sizedList.totalSize + size;
        return index;
    }

    public Double getSize(int index) {
        return this.sizes.get(index);
    }

    public void remove(int index) {
        SizedList sizedList = this;
        sizedList.totalSize = sizedList.totalSize - this.sizes.get(index);
        this.sizes.remove(index);
        this.values.remove(index);
    }

    public Range getRange(int index) {
        Range range = null;
        double currentSize = 0.0;
        for (int i = 0; i < this.sizes.size(); ++i) {
            double newSize = currentSize + this.sizes.get(i);
            if (i == index) {
                range = new Range(currentSize, newSize);
            }
            currentSize = newSize;
        }
        if (range == null) {
            throw new NullPointerException();
        }
        return range;
    }

    public T getValue(double drIndex) {
        if (!(0.0 <= drIndex) || !(this.totalSize > drIndex)) {
            throw new OutOfRangeException(drIndex, 0, this.totalSize);
        }
        T value = null;
        double currentSize = -1.0;
        for (int i = 0; i < this.sizes.size(); ++i) {
            double newSize = currentSize + this.sizes.get(i);
            if (currentSize < drIndex && newSize >= drIndex) {
                value = this.values.get(i);
            }
            currentSize = newSize;
        }
        return value;
    }

    public Double edit(T value, double size) {
        int index = this.indexOf(value);
        if (index >= this.sizes.size()) {
            throw new OutOfRangeException(index, 0, this.sizes.size());
        }
        this.totalSize = this.totalSize - this.sizes.get(index) + size;
        this.sizes.set(index, size);
        return this.sizes.get(index);
    }

    public Double edit(T value, double size, T newValue) {
        int index = this.indexOf(value);
        if (index >= this.sizes.size()) {
            throw new OutOfRangeException(index, 0, this.sizes.size());
        }
        this.totalSize = this.totalSize - this.sizes.get(index) + size;
        this.sizes.set(index, size);
        this.values.set(index, newValue);
        return this.sizes.get(index);
    }

    public Range[] getRanges() {
        Range[] ranges = new Range[]{};
        double currentSize = 0.0;
        for (Double size : this.sizes) {
            double newSize = currentSize + size;
            ranges = ArrayUtils.add(ranges, new Range(currentSize, newSize));
            currentSize = newSize;
        }
        return ranges;
    }

    public Double getTotalSize() {
        return this.totalSize;
    }

    public int indexOf(T value) {
        return this.values.indexOf(value);
    }

    public Range rangeOf(T value) {
        int index = this.values.indexOf(value);
        return this.getRange(index);
    }

    public void editLengths(Applier<T, Double> applier) {
        double currentSize = 0.0;
        ArrayList<Double> sizes2 = new ArrayList<Double>(this.sizes);
        for (int i = 0; i < sizes2.size(); ++i) {
            double applierSize = (Double)applier.apply(this.values.get(i));
            double newSize = currentSize + (Double)sizes2.get(i);
            this.totalSize = this.totalSize - (Double)sizes2.get(i) + applierSize;
            sizes2.set(i, applierSize);
            currentSize = newSize;
        }
        this.sizes = sizes2;
    }
}

