/*
 * Decompiled with CFR 0.152.
 */
package com.ultreon.libs.registries.v0;

import com.ultreon.libs.commons.v0.Identifier;
import com.ultreon.libs.registries.v0.Registry;
import com.ultreon.libs.registries.v0.RegistrySupplier;
import com.ultreon.libs.registries.v0.event.RegistryEvents;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Map;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;

public class DelayedRegister<T> {
    @NotNull
    private final String modId;
    @NotNull
    private final Registry<T> registry;
    private final ArrayList<Map.Entry<Identifier, Supplier<T>>> objects = new ArrayList();

    protected DelayedRegister(@NotNull String modId, @NotNull Registry<T> registry) {
        this.modId = modId;
        this.registry = registry;
    }

    public static <T> DelayedRegister<T> create(String namespace, Registry<T> registry) {
        return new DelayedRegister<T>(namespace, registry);
    }

    public <C extends T> RegistrySupplier<C> register(@NotNull String name, @NotNull @NotNull Supplier<@NotNull C> supplier) {
        Identifier id = new Identifier(this.modId, name);
        this.objects.add(new AbstractMap.SimpleEntry<Identifier, Supplier<Object>>(id, supplier::get));
        return new RegistrySupplier<T>(this.registry, supplier, id);
    }

    public void register() {
        RegistryEvents.AUTO_REGISTER.listen(registry -> {
            if (!registry.getType().equals(this.registry.getType())) {
                return;
            }
            for (Map.Entry<Identifier, Supplier<T>> entry : this.objects) {
                T object = entry.getValue().get();
                Identifier id = entry.getKey();
                if (!registry.getType().isAssignableFrom(object.getClass())) {
                    throw new IllegalArgumentException("Got invalid type in deferred register: " + object.getClass() + " expected assignable to " + registry.getType());
                }
                this.registry.register(id, object);
            }
        });
    }
}

