/*
 * Decompiled with CFR 0.152.
 */
package com.ultreon.data.types;

import com.ultreon.data.Types;
import com.ultreon.data.types.IType;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Arrays;

public class LongArrayType
implements IType<long[]> {
    private long[] obj;

    public LongArrayType(long[] obj) {
        this.obj = obj;
    }

    @Override
    public long[] getValue() {
        return this.obj;
    }

    @Override
    public void setValue(long[] obj) {
        if (obj == null) {
            throw new IllegalArgumentException("Value can't be set to null");
        }
        this.obj = obj;
    }

    @Override
    public int id() {
        return Types.LONG_ARRAY;
    }

    @Override
    public void write(DataOutputStream stream) throws IOException {
        stream.writeInt(this.obj.length);
        for (long l : this.obj) {
            stream.writeLong(l);
        }
    }

    public static LongArrayType read(DataInputStream stream) throws IOException {
        int len = stream.readInt();
        long[] arr = new long[len];
        for (int i = 0; i < len; ++i) {
            arr[i] = stream.readLong();
        }
        return new LongArrayType(arr);
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof LongArrayType)) {
            return false;
        }
        LongArrayType that = (LongArrayType)other;
        return Arrays.equals(this.obj, that.obj);
    }

    @Override
    public int hashCode() {
        return Arrays.hashCode(this.obj);
    }
}

