/*
 * Decompiled with CFR 0.152.
 */
package com.ultreon.data.types;

import com.ultreon.data.Types;
import com.ultreon.data.types.IType;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Objects;

public class FloatType
implements IType<Float> {
    private float obj;

    public FloatType(float obj) {
        this.obj = obj;
    }

    @Override
    public Float getValue() {
        return Float.valueOf(this.obj);
    }

    @Override
    public void setValue(Float obj) {
        if (obj == null) {
            throw new IllegalArgumentException("Value can't be set to null");
        }
        this.obj = obj.floatValue();
    }

    @Override
    public int id() {
        return Types.FLOAT;
    }

    @Override
    public void write(DataOutputStream stream) throws IOException {
        stream.writeFloat(this.obj);
    }

    public static FloatType read(DataInputStream stream) throws IOException {
        return new FloatType(stream.readFloat());
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof FloatType)) {
            return false;
        }
        FloatType floatType = (FloatType)other;
        return Float.compare(this.obj, floatType.obj) == 0;
    }

    @Override
    public int hashCode() {
        return Objects.hash(Float.valueOf(this.obj));
    }
}

