/*
 * Decompiled with CFR 0.152.
 */
package com.ultreon.data;

import com.ultreon.data.IReader;
import com.ultreon.data.Types;
import com.ultreon.data.types.BigDecType;
import com.ultreon.data.types.BigIntType;
import com.ultreon.data.types.BooleanType;
import com.ultreon.data.types.ByteArrayType;
import com.ultreon.data.types.ByteType;
import com.ultreon.data.types.CharType;
import com.ultreon.data.types.DoubleArrayType;
import com.ultreon.data.types.DoubleType;
import com.ultreon.data.types.FloatArrayType;
import com.ultreon.data.types.FloatType;
import com.ultreon.data.types.IType;
import com.ultreon.data.types.IntArrayType;
import com.ultreon.data.types.IntType;
import com.ultreon.data.types.ListType;
import com.ultreon.data.types.LongArrayType;
import com.ultreon.data.types.LongType;
import com.ultreon.data.types.MapType;
import com.ultreon.data.types.ShortArrayType;
import com.ultreon.data.types.ShortType;
import com.ultreon.data.types.StringType;
import com.ultreon.data.types.UUIDType;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class TypeRegistry {
    private static final Map<Integer, IReader<? extends IType<?>>> READERS = new HashMap();
    private static final Map<Integer, Class<? extends IType<?>>> TYPES = new HashMap();
    private static final Map<String, Integer> ID_MAP = new HashMap<String, Integer>();

    @SafeVarargs
    public static <T extends IType<?>> void register(int id, IReader<T> reader, T ... type) {
        Class<?> componentType = type.getClass().getComponentType();
        READERS.put(id, reader);
        TYPES.put(id, componentType);
        ID_MAP.put(componentType.getName(), id);
    }

    public static IType<?> read(int id, DataInputStream stream) throws IOException {
        return READERS.get(id).read(stream);
    }

    public static Class<? extends IType<?>> getType(int id) {
        return TYPES.get(id);
    }

    public static int getId(Class<?> componentType) {
        return ID_MAP.get(componentType.getName());
    }

    static {
        TypeRegistry.register((int)Types.BYTE, ByteType::read, (IType[])new ByteType[0]);
        TypeRegistry.register((int)Types.SHORT, ShortType::read, (IType[])new ShortType[0]);
        TypeRegistry.register((int)Types.INT, IntType::read, (IType[])new IntType[0]);
        TypeRegistry.register((int)Types.LONG, LongType::read, (IType[])new LongType[0]);
        TypeRegistry.register((int)Types.BIG_INT, BigIntType::read, (IType[])new BigIntType[0]);
        TypeRegistry.register((int)Types.FLOAT, FloatType::read, (IType[])new FloatType[0]);
        TypeRegistry.register((int)Types.DOUBLE, DoubleType::read, (IType[])new DoubleType[0]);
        TypeRegistry.register((int)Types.BIG_DEC, BigDecType::read, (IType[])new BigDecType[0]);
        TypeRegistry.register((int)Types.CHAR, CharType::read, (IType[])new CharType[0]);
        TypeRegistry.register((int)Types.BOOLEAN, BooleanType::read, (IType[])new BooleanType[0]);
        TypeRegistry.register((int)Types.STRING, StringType::read, (IType[])new StringType[0]);
        TypeRegistry.register((int)Types.LIST, ListType::read, (IType[])new ListType[0]);
        TypeRegistry.register((int)Types.MAP, MapType::read, (IType[])new MapType[0]);
        TypeRegistry.register((int)Types.BYTE_ARRAY, ByteArrayType::read, (IType[])new ByteArrayType[0]);
        TypeRegistry.register((int)Types.SHORT_ARRAY, ShortArrayType::read, (IType[])new ShortArrayType[0]);
        TypeRegistry.register((int)Types.INT_ARRAY, IntArrayType::read, (IType[])new IntArrayType[0]);
        TypeRegistry.register((int)Types.LONG_ARRAY, LongArrayType::read, (IType[])new LongArrayType[0]);
        TypeRegistry.register((int)Types.FLOAT_ARRAY, FloatArrayType::read, (IType[])new FloatArrayType[0]);
        TypeRegistry.register((int)Types.DOUBLE_ARRAY, DoubleArrayType::read, (IType[])new DoubleArrayType[0]);
        TypeRegistry.register((int)Types.UUID, UUIDType::read, (IType[])new UUIDType[0]);
    }
}

