/*
 * Decompiled with CFR 0.152.
 */
package com.ultreon.libs.resources.v0.android;

import com.ultreon.libs.commons.v0.Identifier;
import com.ultreon.libs.functions.v0.misc.ThrowingSupplier;
import com.ultreon.libs.resources.v0.Resource;
import com.ultreon.libs.resources.v0.ResourcePackage;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import org.jetbrains.annotations.NotNull;

public class DeferredResourcePackage
extends ResourcePackage {
    private final Class<?> ref;
    private final String root;

    public DeferredResourcePackage(Class<?> ref, String root) {
        super(new HashMap<Identifier, Resource>());
        this.ref = ref;
        this.root = root;
    }

    @Override
    public boolean has(Identifier entry) {
        return this.getUrl(entry) != null;
    }

    private URL getUrl(Identifier entry) {
        return this.ref.getResource(this.getPath(entry));
    }

    @NotNull
    private String getPath(Identifier entry) {
        return "/" + this.root + "/" + entry.location() + "/" + entry.path();
    }

    @Override
    public Resource get(Identifier entry) {
        if (!this.has(entry)) {
            return null;
        }
        if (this.resources.containsKey(entry)) {
            return (Resource)this.resources.get(entry);
        }
        Resource resource = new Resource((ThrowingSupplier<InputStream, IOException>)((ThrowingSupplier)() -> this.ref.getResourceAsStream(this.getPath(entry))));
        this.resources.put(entry, resource);
        return resource;
    }
}

