/*
 * Decompiled with CFR 0.152.
 */
package com.ultreon.libs.registries.v0;

import com.ultreon.libs.collections.v0.maps.OrderedHashMap;
import com.ultreon.libs.commons.v0.Identifier;
import com.ultreon.libs.commons.v0.Logger;
import com.ultreon.libs.registries.v0.event.RegistryEvents;
import com.ultreon.libs.registries.v0.exception.RegistryException;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.Nullable;

public class Registry<T> {
    public static Logger dumpLogger = (level, msg, t) -> {};
    private static final OrderedHashMap<Class<?>, Registry<?>> REGISTRIES = new OrderedHashMap();
    private static boolean frozen;
    private final OrderedHashMap<Identifier, T> keyMap = new OrderedHashMap();
    private final OrderedHashMap<T, Identifier> valueMap = new OrderedHashMap();
    private final Class<T> type;
    private final Identifier id;

    protected Registry(Class<T> clazz, Identifier id) throws IllegalStateException {
        this.id = id;
        this.type = clazz;
        RegistryEvents.REGISTRY_DUMP.listen(this::dumpRegistry);
    }

    public static Collection<Registry<?>> getRegistries() {
        return REGISTRIES.values();
    }

    public static void freeze() {
        frozen = true;
    }

    public Identifier id() {
        return this.id;
    }

    @SafeVarargs
    public static <T> Registry<T> create(Identifier registryName, T ... type) {
        Class<?> componentType = type.getClass().getComponentType();
        if (REGISTRIES.containsKey(componentType)) {
            throw new IllegalStateException();
        }
        Registry registry = new Registry(componentType, registryName);
        REGISTRIES.put(componentType, registry);
        return registry;
    }

    @Nullable
    public Identifier getKey(T obj) {
        return (Identifier)this.valueMap.get(obj);
    }

    public T getValue(@Nullable Identifier key) {
        if (!this.keyMap.containsKey((Object)key)) {
            throw new RegistryException("Cannot find object for: " + key + " | type: " + this.type.getSimpleName());
        }
        return (T)this.keyMap.get((Object)key);
    }

    public boolean contains(Identifier rl) {
        return this.keyMap.containsKey((Object)rl);
    }

    public void dumpRegistry() {
        dumpLogger.log("Registry dump: " + this.type.getSimpleName());
        for (Map.Entry<Identifier, T> entry : this.entries()) {
            T object = entry.getValue();
            Identifier rl = entry.getKey();
            dumpLogger.log("  (" + rl + ") -> " + object);
        }
    }

    public void register(Identifier rl, T val) {
        if (!this.type.isAssignableFrom(val.getClass())) {
            throw new IllegalArgumentException("Not allowed type detected, got " + val.getClass() + " expected assignable to " + this.type);
        }
        this.keyMap.put((Object)rl, val);
        this.valueMap.put(val, (Object)rl);
    }

    public Collection<T> values() {
        return Collections.unmodifiableCollection(this.keyMap.values());
    }

    public Set<Identifier> keys() {
        return Collections.unmodifiableSet(this.keyMap.keySet());
    }

    public Set<Map.Entry<Identifier, T>> entries() {
        ArrayList<T> values = new ArrayList<T>(this.values());
        ArrayList<Identifier> keys = new ArrayList<Identifier>(this.keys());
        if (keys.size() != values.size()) {
            throw new IllegalStateException("Keys and values have different lengths.");
        }
        HashSet<AbstractMap.SimpleEntry<Identifier, T>> entrySet = new HashSet<AbstractMap.SimpleEntry<Identifier, T>>();
        for (int i = 0; i < keys.size(); ++i) {
            entrySet.add(new AbstractMap.SimpleEntry<Identifier, T>(keys.get(i), values.get(i)));
        }
        return Collections.unmodifiableSet(entrySet);
    }

    public Class<T> getType() {
        return this.type;
    }

    public static void dump() {
        for (Registry registry : REGISTRIES.values()) {
            dumpLogger.log("Registry: (" + registry.id() + ") -> {");
            dumpLogger.log("  Type: " + registry.getType().getName() + ";");
            for (Map.Entry entry : registry.entries()) {
                Object o = null;
                String className = null;
                try {
                    o = entry.getValue();
                    className = o.getClass().getName();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                dumpLogger.log("  (" + entry.getKey() + ") -> {");
                dumpLogger.log("    Class : " + className + ";");
                dumpLogger.log("    Object: " + o + ";");
                dumpLogger.log("  }");
            }
            dumpLogger.log("}");
        }
    }

    public boolean isFrozen() {
        return frozen;
    }
}

