/*
 * Decompiled with CFR 0.152.
 */
package com.ultreon.data.types;

import com.ultreon.data.TypeRegistry;
import com.ultreon.data.Types;
import com.ultreon.data.types.IType;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;

public class ListType<T extends IType<?>>
implements IType<List<T>>,
Iterable<T> {
    private final int id;
    Class<?> componentType;
    private List<T> obj;

    public ListType(int id) {
        this((List<T>)new ArrayList(), id);
    }

    @SafeVarargs
    public ListType(T ... type) {
        this(type.getClass().getComponentType());
    }

    @SafeVarargs
    public ListType(List<T> obj, T ... type) {
        this(obj, type.getClass().getComponentType());
    }

    private ListType(Class<?> type) {
        this((List<T>)new ArrayList(), TypeRegistry.getId(type));
    }

    private ListType(List<T> obj, Class<?> type) {
        this.obj = obj;
        this.id = TypeRegistry.getId(type);
        this.componentType = type;
    }

    private ListType(List<T> list, int id) {
        this.setValue(list);
        this.id = id;
        this.componentType = TypeRegistry.getType(id);
    }

    @Override
    public List<T> getValue() {
        return this.obj;
    }

    @Override
    public void setValue(List<T> obj) {
        int id = -1;
        ArrayList<T> list = new ArrayList<T>();
        int objSize = obj.size();
        for (int i = 0; i < objSize; ++i) {
            IType iType = (IType)obj.get(i);
            if (id == -1) {
                id = iType.id();
            }
            if (id != iType.id()) {
                throw new IllegalArgumentException("Type at index " + i + " has invalid id: " + iType.id() + " (expected " + id + ")");
            }
            list.add(iType);
        }
        this.obj = list;
    }

    @Override
    public int id() {
        return Types.LIST;
    }

    @Override
    public void write(DataOutputStream stream) throws IOException {
        stream.writeByte(this.id);
        stream.writeInt(this.obj.size());
        for (IType l : this.obj) {
            l.write(stream);
        }
    }

    public static ListType<?> read(DataInputStream stream) throws IOException {
        byte id = stream.readByte();
        int len = stream.readInt();
        ArrayList list = new ArrayList();
        for (int i = 0; i < len; ++i) {
            list.add(TypeRegistry.read(id, stream));
        }
        return new ListType(list, id);
    }

    public void add(T type) {
        this.obj.add(type);
    }

    @Override
    public Iterator<T> iterator() {
        return new Iterator<T>(){
            private final List<T> list;
            private int index;
            {
                this.list = new ArrayList(ListType.this.getValue());
                this.index = 0;
            }

            @Override
            public boolean hasNext() {
                return this.index < this.list.size();
            }

            @Override
            public T next() {
                return (IType)this.list.get(this.index++);
            }
        };
    }

    public int type() {
        return this.id;
    }

    @SafeVarargs
    public final <C extends IType<?>> ListType<C> cast(C ... type) {
        return this.cast(type.getClass().getComponentType());
    }

    final <C extends IType<?>> ListType<C> cast(Class<?> type) {
        ListType<T> cs = new ListType<T>(type);
        cs.setValue(this.obj);
        return cs;
    }

    public T get(int index) {
        return (T)((IType)this.obj.get(index));
    }

    public boolean remove(int index) {
        return this.obj.remove(this.get(index));
    }

    public T pop(int index) {
        return (T)((IType)this.obj.remove(index));
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ListType)) {
            return false;
        }
        ListType listType = (ListType)other;
        return this.id == listType.id && Objects.equals(this.obj, listType.obj);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.id, this.obj);
    }
}

