/*
 * Decompiled with CFR 0.152.
 */
package com.ultreon.data.types;

import com.ultreon.data.Types;
import com.ultreon.data.types.IType;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Objects;

public class BigDecType
implements IType<BigDecimal> {
    private BigDecimal obj;

    public BigDecType(BigDecimal obj) {
        this.obj = obj;
    }

    @Override
    public BigDecimal getValue() {
        return this.obj;
    }

    @Override
    public void setValue(BigDecimal obj) {
        if (obj == null) {
            throw new IllegalArgumentException("Value can't be set to null");
        }
        this.obj = obj;
    }

    @Override
    public int id() {
        return Types.BIG_DEC;
    }

    @Override
    public void write(DataOutputStream stream) throws IOException {
        byte[] bytes = this.obj.unscaledValue().toByteArray();
        stream.writeInt(bytes.length);
        stream.writeInt(this.obj.scale());
        for (byte aByte : bytes) {
            stream.writeByte(aByte);
        }
    }

    public static BigDecType read(DataInputStream stream) throws IOException {
        int len = stream.readInt();
        int scale = stream.readInt();
        byte[] bytes = new byte[len];
        for (int i = 0; i < len; ++i) {
            bytes[i] = stream.readByte();
        }
        return new BigDecType(new BigDecimal(new BigInteger(bytes), scale));
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof BigDecType)) {
            return false;
        }
        BigDecType that = (BigDecType)other;
        return Objects.equals(this.obj, that.obj);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.obj);
    }
}

