/*
 * Decompiled with CFR 0.152.
 */
package com.ultreon.libs.translations.v0;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.ultreon.libs.commons.v0.Identifier;
import com.ultreon.libs.translations.v0.LanguageManager;
import java.util.Locale;

public class Language {
    private final Locale locale;
    private final JsonObject root;
    private final Identifier id;

    public Language(Locale locale, JsonObject json, Identifier id) {
        this.locale = locale;
        this.root = json;
        this.id = id;
    }

    public String get(String path, Object ... args) {
        String s;
        String[] split = path.split("/");
        JsonObject object = this.root;
        int splitLength = split.length;
        for (int i = 0; i < splitLength - 1; ++i) {
            s = split[i];
            JsonElement element = object.get(s);
            if (!(element instanceof JsonObject)) {
                return null;
            }
            object = (JsonObject)element;
        }
        JsonElement element = object.get(split[split.length - 1]);
        if (element instanceof JsonPrimitive) {
            JsonPrimitive primitive = (JsonPrimitive)element;
            s = primitive.getAsString();
            return s == null ? "null" : String.format(s, args);
        }
        return null;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public Identifier getId() {
        return this.id;
    }

    public static String translate(String path, Object ... args) {
        Language language = LanguageManager.INSTANCE.get(LanguageManager.getCurrentLanguage());
        if (language == null) {
            return Language.translateFallback(path, args);
        }
        String s = language.get(path, args);
        return s == null ? Language.translateFallback(path, args) : s;
    }

    private static String translateFallback(String path, Object[] args) {
        Language english = LanguageManager.INSTANCE.get(new Locale("en"));
        if (english == null) {
            throw new IllegalStateException("English language not loaded");
        }
        String s = english.get(path, args);
        return s == null ? path : s;
    }
}

