/*
 * Decompiled with CFR 0.152.
 */
package com.ultreon.libs.commons.v0;

import java.util.NoSuchElementException;
import java.util.function.Consumer;
import java.util.function.Supplier;

public class Either<L, R> {
    private final Left<L> left;
    private final Right<R> right;

    private Either(Left<L> left, Right<R> right) {
        this.left = left;
        this.right = right;
    }

    public static <L, R> Either<L, R> left(L left) {
        return new Either<L, R>(new Left<L>(left), null);
    }

    public static <L, R> Either<L, R> right(R right) {
        return new Either<L, R>(null, new Right<R>(right));
    }

    public L getLeft() {
        if (this.left == null) {
            throw new NoSuchElementException("The left part of the either is not present.");
        }
        return (L)((Left)this.left).value;
    }

    public R getRight() {
        if (this.right == null) {
            throw new NoSuchElementException("The right part of the either is not present.");
        }
        return (R)((Right)this.right).value;
    }

    public boolean isLeftPresent() {
        return this.left != null;
    }

    public boolean isRightPresent() {
        return this.right != null;
    }

    public void ifLeft(Consumer<L> onLeft) {
        if (this.left != null) {
            onLeft.accept(((Left)this.left).value);
        }
    }

    public void ifRight(Consumer<R> onRight) {
        if (this.right != null) {
            onRight.accept(((Right)this.right).value);
        }
    }

    public void ifLeftOrElse(Consumer<L> onLeft, Runnable runnable) {
        if (this.left != null) {
            onLeft.accept(((Left)this.left).value);
        } else {
            runnable.run();
        }
    }

    public void ifRightOrElse(Consumer<R> onRight, Runnable runnable) {
        if (this.right != null) {
            onRight.accept(((Right)this.right).value);
        } else {
            runnable.run();
        }
    }

    public L getLeftOrNull() {
        return (L)((Left)this.left).value;
    }

    public R getRightOrNull() {
        return (R)((Right)this.right).value;
    }

    public L getLeftOrNullOr(L other) {
        Object value = ((Left)this.left).value;
        return (L)(value == null ? other : value);
    }

    public R getRightOrNullOr(R other) {
        Object value = ((Right)this.right).value;
        return (R)(value == null ? other : value);
    }

    public L getLeftOrNullOrGet(Supplier<? extends L> other) {
        Object value = ((Left)this.left).value;
        return (L)(value == null ? other.get() : value);
    }

    public R getRightOrNullOr(Supplier<? extends R> other) {
        Object value = ((Right)this.right).value;
        return (R)(value == null ? other.get() : value);
    }

    public void ifAny(Consumer<L> onLeft, Consumer<R> onRight) {
        if (this.left != null) {
            onLeft.accept(((Left)this.left).value);
        } else if (this.right != null) {
            onRight.accept(((Right)this.right).value);
        }
    }

    private static class Right<R> {
        private final R value;

        public Right(R value) {
            this.value = value;
        }
    }

    private static class Left<L> {
        private final L value;

        public Left(L value) {
            this.value = value;
        }
    }
}

