/*
 * Decompiled with CFR 0.152.
 */
package com.ultreon.libs.commons.v0;

import com.ultreon.libs.commons.v0.exceptions.InvalidValueException;
import java.util.regex.Pattern;
import org.jetbrains.annotations.ApiStatus;

public class Color {
    public static Color black = Color.rgb(0);
    public static Color darkGray = Color.rgb(0x404040);
    public static Color gray = Color.rgb(0x808080);
    public static Color lightGray = Color.rgb(0xC0C0C0);
    public static Color white = Color.rgb(0xFFFFFF);
    public static Color red = Color.rgb(0xFF0000);
    public static Color orange = Color.rgb(0xFF8000);
    public static Color gold = Color.rgb(0xFFB000);
    public static Color yellow = Color.rgb(0xFFFF00);
    public static Color yellowGreen = Color.rgb(0x80FF00);
    public static Color green = Color.rgb(65280);
    public static Color mint = Color.rgb(65408);
    public static Color cyan = Color.rgb(65535);
    public static Color azure = Color.rgb(33023);
    public static Color blue = Color.rgb(255);
    public static Color purple = Color.rgb(0x8000FF);
    public static Color magenta = Color.rgb(0xFF00FF);
    public static Color rose = Color.rgb(0xFF0080);
    public static Color transparent = Color.rgba(0);
    private final java.awt.Color awtColor;

    private Color(long red, long green, long blue, long alpha) {
        this.awtColor = new java.awt.Color((int)red, (int)green, (int)blue, (int)alpha);
    }

    private Color(int red, int green, int blue, int alpha) {
        this.awtColor = new java.awt.Color(red, green, blue, alpha);
    }

    private Color(java.awt.Color color) {
        this.awtColor = color;
    }

    public static Color hsb(float h, float s, float b) {
        return new Color(java.awt.Color.getHSBColor(h, s, b));
    }

    public static Color rgb(int red, int green, int blue) {
        return new Color(red, green, blue, 255);
    }

    public static Color rgb(float red, float green, float blue) {
        return new Color((int)(red * 255.0f), (int)(green * 255.0f), (int)(blue * 255.0f), 255);
    }

    public static Color rgba(int red, int green, int blue, int alpha) {
        return new Color(red, green, blue, alpha);
    }

    public static Color rgba(float red, float green, float blue, float alpha) {
        return new Color((int)(red * 255.0f), (int)(green * 255.0f), (int)(blue * 255.0f), (int)(alpha * 255.0f));
    }

    public static Color rgb(int color) {
        long rgb = (long)color % 0x100000000L;
        return new Color((rgb & 0xFF0000L) >> 16, (rgb & 0xFF00L) >> 8, rgb & 0xFFL, 255L);
    }

    public static Color rgba(int color) {
        long rgba = (long)color % 0x100000000L;
        return new Color((rgba & 0xFF000000L) >> 24, (rgba & 0xFF0000L) >> 16, (rgba & 0xFF00L) >> 8, rgba & 0xFFL);
    }

    public static Color argb(int color) {
        long argb = (long)color % 0x100000000L;
        return new Color((argb & 0xFF0000L) >> 16, (argb & 0xFF00L) >> 8, argb & 0xFFL, (argb & 0xFF000000L) >> 24);
    }

    public static Color bgr(int color) {
        long bgr = (long)color % 0x100000000L;
        return new Color(bgr & 0xFFL, (bgr & 0xFF00L) >> 8, (bgr & 0xFF0000L) >> 16, 255L);
    }

    public static Color bgra(int color) {
        long bgra = (long)color % 0x100000000L;
        return new Color((bgra & 0xFF00L) >> 8, (bgra & 0xFF0000L) >> 16, (bgra & 0xFF000000L) >> 24, bgra & 0xFFL);
    }

    public static Color abgr(int color) {
        long abgr = (long)color % 0x100000000L;
        return new Color(abgr & 0xFFL, (abgr & 0xFF00L) >> 8, (abgr & 0xFF0000L) >> 16, (abgr & 0xFF000000L) >> 24);
    }

    public static Color hex(String hex) {
        if (Pattern.matches("#[0-9a-fA-F]{6}", hex)) {
            int rgb = Integer.valueOf(hex.substring(1), 16);
            return Color.rgb(rgb);
        }
        if (Pattern.matches("#[0-9a-fA-F]{8}", hex)) {
            int rgb = Integer.valueOf(hex.substring(1), 16);
            return Color.rgba(rgb);
        }
        if (Pattern.matches("#[0-9a-fA-F]{3}", hex)) {
            int rgb = Integer.valueOf(new String(new char[]{hex.charAt(1), hex.charAt(1), hex.charAt(2), hex.charAt(2), hex.charAt(3), hex.charAt(3)}), 16);
            return Color.rgb(rgb);
        }
        if (Pattern.matches("#[0-9a-fA-F]{4}", hex)) {
            int rgb = Integer.valueOf(new String(new char[]{hex.charAt(1), hex.charAt(1), hex.charAt(2), hex.charAt(2), hex.charAt(3), hex.charAt(3), hex.charAt(4), hex.charAt(4)}), 16);
            return Color.rgba(rgb);
        }
        if (hex.length() >= 1) {
            if (hex.charAt(0) != '#') {
                throw new InvalidValueException("First character create color code isn't '#'.");
            }
            if (hex.length() != 3 && hex.length() != 4 && hex.length() != 6 && hex.length() != 8) {
                throw new InvalidValueException("Invalid hex length, should be 3, 4, 6 or 8 in length.");
            }
            throw new InvalidValueException("Invalid hex value. Hex values may only contain numbers and letters a to f.");
        }
        throw new InvalidValueException("The color hex is empty, it should start with a hex, and then 3, 4, 6 or 8 hexadecimal digits.");
    }

    @ApiStatus.Internal
    public static Color awt(java.awt.Color awt) {
        return new Color(awt);
    }

    public java.awt.Color toAwt() {
        return this.awtColor;
    }

    public Color brighter() {
        return new Color(this.awtColor.brighter());
    }

    public Color darker() {
        return new Color(this.awtColor.darker());
    }

    public int getRed() {
        return this.awtColor.getRed();
    }

    public int getGreen() {
        return this.awtColor.getGreen();
    }

    public int getBlue() {
        return this.awtColor.getBlue();
    }

    public int getAlpha() {
        return this.awtColor.getAlpha();
    }

    public int getTransparency() {
        return this.awtColor.getTransparency();
    }

    public int getRgb() {
        return this.awtColor.getRGB();
    }

    public Color withRed(int red) {
        return new Color(red, this.getGreen(), this.getBlue(), this.getAlpha());
    }

    public Color withGreen(int green) {
        return new Color(this.getRed(), green, this.getBlue(), this.getAlpha());
    }

    public Color withBlue(int blue) {
        return new Color(this.getRed(), this.getGreen(), blue, this.getAlpha());
    }

    public Color withAlpha(int alpha) {
        return new Color(this.getRed(), this.getGreen(), this.getBlue(), alpha);
    }

    public String toString() {
        return String.format("#%02x%02x%02x%02x", this.getRed(), this.getGreen(), this.getBlue(), this.getAlpha());
    }
}

