/*
 * Decompiled with CFR 0.152.
 */
package com.qsoftware.modlib.utils.helpers;

import java.util.Collection;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.util.Direction;
import net.minecraft.util.math.shapes.IBooleanFunction;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;

public class VoxelShapeHelper {
    public static VoxelShape combineAll(Collection<VoxelShape> shapes) {
        VoxelShape result = VoxelShapes.func_197880_a();
        for (VoxelShape shape : shapes) {
            result = VoxelShapes.func_197882_b((VoxelShape)result, (VoxelShape)shape, (IBooleanFunction)IBooleanFunction.field_223244_o_);
        }
        return result.func_197753_c();
    }

    public static VoxelShape setMaxHeight(VoxelShape source, double height) {
        AtomicReference<VoxelShape> result = new AtomicReference<VoxelShape>(VoxelShapes.func_197880_a());
        source.func_197755_b((minX, minY, minZ, maxX, maxY, maxZ) -> {
            VoxelShape shape = VoxelShapes.func_197873_a((double)minX, (double)minY, (double)minZ, (double)maxX, (double)height, (double)maxZ);
            result.set(VoxelShapes.func_197882_b((VoxelShape)((VoxelShape)result.get()), (VoxelShape)shape, (IBooleanFunction)IBooleanFunction.field_223244_o_));
        });
        return result.get().func_197753_c();
    }

    public static VoxelShape limitHorizontal(VoxelShape source) {
        AtomicReference<VoxelShape> result = new AtomicReference<VoxelShape>(VoxelShapes.func_197880_a());
        source.func_197755_b((minX, minY, minZ, maxX, maxY, maxZ) -> {
            VoxelShape shape = VoxelShapes.func_197873_a((double)VoxelShapeHelper.limit(minX), (double)minY, (double)VoxelShapeHelper.limit(minZ), (double)VoxelShapeHelper.limit(maxX), (double)maxY, (double)VoxelShapeHelper.limit(maxZ));
            result.set(VoxelShapes.func_197882_b((VoxelShape)((VoxelShape)result.get()), (VoxelShape)shape, (IBooleanFunction)IBooleanFunction.field_223244_o_));
        });
        return result.get().func_197753_c();
    }

    public static VoxelShape[] getRotatedShapes(VoxelShape source) {
        VoxelShape shapeNorth = VoxelShapeHelper.rotate(source, Direction.NORTH);
        VoxelShape shapeEast = VoxelShapeHelper.rotate(source, Direction.EAST);
        VoxelShape shapeSouth = VoxelShapeHelper.rotate(source, Direction.SOUTH);
        VoxelShape shapeWest = VoxelShapeHelper.rotate(source, Direction.WEST);
        return new VoxelShape[]{shapeSouth, shapeWest, shapeNorth, shapeEast};
    }

    public static VoxelShape rotate(VoxelShape source, Direction direction) {
        double[] adjustedValues = VoxelShapeHelper.adjustValues(direction, source.func_197762_b(Direction.Axis.X), source.func_197762_b(Direction.Axis.Z), source.func_197758_c(Direction.Axis.X), source.func_197758_c(Direction.Axis.Z));
        return VoxelShapes.func_197873_a((double)adjustedValues[0], (double)source.func_197762_b(Direction.Axis.Y), (double)adjustedValues[1], (double)adjustedValues[2], (double)source.func_197758_c(Direction.Axis.Y), (double)adjustedValues[3]);
    }

    private static double[] adjustValues(Direction direction, double var1, double var2, double var3, double var4) {
        switch (direction) {
            case WEST: {
                double var_temp_1 = var1;
                var1 = 1.0 - var3;
                double var_temp_2 = var2;
                var2 = 1.0 - var4;
                var3 = 1.0 - var_temp_1;
                var4 = 1.0 - var_temp_2;
                break;
            }
            case NORTH: {
                double var_temp_3 = var1;
                var1 = var2;
                var2 = 1.0 - var3;
                var3 = var4;
                var4 = 1.0 - var_temp_3;
                break;
            }
            case SOUTH: {
                double var_temp_4 = var1;
                var1 = 1.0 - var4;
                double var_temp_5 = var2;
                var2 = var_temp_4;
                double var_temp_6 = var3;
                var3 = 1.0 - var_temp_5;
                var4 = var_temp_6;
                break;
            }
        }
        return new double[]{var1, var2, var3, var4};
    }

    private static double limit(double value) {
        return Math.max(0.0, Math.min(1.0, value));
    }
}

