/*
 * Decompiled with CFR 0.152.
 */
package com.qsoftware.modlib.utils.builder;

import java.util.ArrayList;
import java.util.Collection;
import java.util.stream.Stream;
import net.minecraft.item.IItemTier;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.tags.ITag;
import net.minecraft.util.IItemProvider;

public class ItemTierBuilder {
    private int harvestLevel = 0;
    private int maxUses = -1;
    private float efficiency;
    private float attackDamage;
    private int enchantability;
    private Ingredient repairMaterial;

    public ItemTierBuilder harvestLevel(int harvestLevel) {
        this.harvestLevel = harvestLevel;
        return this;
    }

    public ItemTierBuilder maxUses(int maxUses) {
        this.maxUses = maxUses;
        return this;
    }

    public ItemTierBuilder efficiency(float efficiency) {
        this.efficiency = efficiency;
        return this;
    }

    public ItemTierBuilder attackDamage(float attackDamage) {
        this.attackDamage = attackDamage;
        return this;
    }

    public ItemTierBuilder enchantability(int enchantability) {
        this.enchantability = enchantability;
        return this;
    }

    public ItemTierBuilder repairMaterial(ITag<Item> tag) {
        this.repairMaterial = Ingredient.func_199805_a(tag);
        return this;
    }

    public ItemTierBuilder repairMaterial(ItemStack ... stacks) {
        this.repairMaterial = Ingredient.func_193369_a((ItemStack[])stacks);
        return this;
    }

    public ItemTierBuilder repairMaterial(Stream<ItemStack> stacks) {
        this.repairMaterial = Ingredient.func_234819_a_(stacks);
        return this;
    }

    public ItemTierBuilder repairMaterial(Collection<ItemStack> stacks) {
        this.repairMaterial = Ingredient.func_234819_a_(stacks.stream());
        return this;
    }

    public ItemTierBuilder repairMaterial(Iterable<ItemStack> stacks) {
        ArrayList<ItemStack> itemStackList = new ArrayList<ItemStack>();
        for (ItemStack stack : stacks) {
            itemStackList.add(stack);
        }
        return this.repairMaterial((Collection<ItemStack>)itemStackList);
    }

    public ItemTierBuilder repairMaterial(IItemProvider ... items) {
        this.repairMaterial = Ingredient.func_199804_a((IItemProvider[])items);
        return this;
    }

    public ItemTierBuilder repairMaterial(Ingredient ingredient) {
        this.repairMaterial = ingredient;
        return this;
    }

    public IItemTier build() {
        return new IItemTier(){

            public int func_200926_a() {
                return ItemTierBuilder.this.maxUses;
            }

            public float func_200928_b() {
                return ItemTierBuilder.this.efficiency;
            }

            public float func_200929_c() {
                return ItemTierBuilder.this.attackDamage;
            }

            public int func_200925_d() {
                return ItemTierBuilder.this.harvestLevel;
            }

            public int func_200927_e() {
                return ItemTierBuilder.this.enchantability;
            }

            public Ingredient func_200924_f() {
                return ItemTierBuilder.this.repairMaterial;
            }
        };
    }
}

