/*
 * Decompiled with CFR 0.152.
 */
package com.qsoftware.modlib.utils;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.item.ItemStack;

public final class GraphicsUtil {
    private final ItemRenderer itemRenderer;
    private final MatrixStack matrixStack;
    private final FontRenderer fontRenderer;

    public GraphicsUtil(ItemRenderer itemRenderer, MatrixStack matrixStack, FontRenderer fontRenderer) {
        this.itemRenderer = itemRenderer;
        this.matrixStack = matrixStack;
        this.fontRenderer = fontRenderer;
    }

    public void blit(int x, int y, int blitOffset, int width, int height, TextureAtlasSprite sprite) {
        ContainerScreen.func_238470_a_((MatrixStack)this.matrixStack, (int)x, (int)y, (int)blitOffset, (int)width, (int)height, (TextureAtlasSprite)sprite);
    }

    public void blit(int x, int y, int blitOffset, float uOffset, float vOffset, int uWidth, int vHeight, int textureHeight, int textureWidth) {
        ContainerScreen.func_238464_a_((MatrixStack)this.matrixStack, (int)x, (int)y, (int)blitOffset, (float)uOffset, (float)vOffset, (int)uWidth, (int)vHeight, (int)textureHeight, (int)textureWidth);
    }

    public void blit(int x, int y, int width, int height, float uOffset, float vOffset, int uWidth, int vHeight, int textureWidth, int textureHeight) {
        ContainerScreen.func_238466_a_((MatrixStack)this.matrixStack, (int)x, (int)y, (int)width, (int)height, (float)uOffset, (float)vOffset, (int)uWidth, (int)vHeight, (int)textureWidth, (int)textureHeight);
    }

    public void blit(int x, int y, float uOffset, float vOffset, int width, int height, int textureWidth, int textureHeight) {
        ContainerScreen.func_238463_a_((MatrixStack)this.matrixStack, (int)x, (int)y, (float)uOffset, (float)vOffset, (int)width, (int)height, (int)textureWidth, (int)textureHeight);
    }

    public final void drawCenteredString(String text, float x, float y, int color) {
        this.drawCenteredString(text, x, y, color, false);
    }

    public final void drawCenteredString(String text, float x, float y, int color, boolean shadow) {
        if (shadow) {
            this.fontRenderer.func_238405_a_(this.matrixStack, text, x - (float)((int)((float)this.fontRenderer.func_78256_a(text) / 2.0f)), y, color);
        } else {
            this.fontRenderer.func_238421_b_(this.matrixStack, text, x - (float)((int)((float)this.fontRenderer.func_78256_a(text) / 2.0f)), y, color);
        }
    }

    public final void drawItemStack(ItemStack stack, int x, int y, String altText) {
        RenderSystem.translatef((float)0.0f, (float)0.0f, (float)32.0f);
        this.itemRenderer.field_77023_b = 200.0f;
        FontRenderer font = stack.func_77973_b().getFontRenderer(stack);
        if (font == null) {
            font = Minecraft.func_71410_x().field_71466_p;
        }
        this.itemRenderer.func_180450_b(stack, x, y);
        this.itemRenderer.func_180453_a(font, stack, x, y - (stack.func_190926_b() ? 0 : 8), altText);
        this.itemRenderer.field_77023_b = 0.0f;
    }
}

