/*
 * Decompiled with CFR 0.152.
 */
package com.qsoftware.modlib.silentlib.util;

import com.qsoftware.modlib.silentlib.util.DimPos;
import com.qsoftware.modlib.silentlib.util.DimensionId;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.util.ITeleporter;

public class TeleportUtils {
    public static void teleport(PlayerEntity player, DimPos pos, @Nullable Direction direction) {
        TeleportUtils.teleport(player, pos.getDimensionId(), (double)pos.getX() + 0.5, pos.getY(), (double)pos.getZ() + 0.5, direction);
    }

    public static void teleport(PlayerEntity player, DimensionId dimension, double destX, double destY, double destZ, @Nullable Direction direction) {
        DimensionId oldId = DimensionId.fromWorld(player.func_130014_f_());
        float rotationYaw = player.field_70177_z;
        float rotationPitch = player.field_70125_A;
        if (!oldId.equals(dimension)) {
            TeleportUtils.teleportToDimension(player, dimension, destX, destY, destZ);
        }
        if (direction != null) {
            TeleportUtils.fixOrientation((Entity)player, destX, destY, destZ, direction);
        } else {
            player.field_70177_z = rotationYaw;
            player.field_70125_A = rotationPitch;
        }
        player.func_70634_a(destX, destY, destZ);
    }

    public static void teleportToDimension(PlayerEntity player, DimensionId dimension, final double x, final double y, final double z) {
        final ServerWorld world = dimension.loadWorld(player.func_130014_f_());
        player.changeDimension(world, new ITeleporter(){

            public Entity placeEntity(Entity entity, ServerWorld currentWorld, ServerWorld destWorld, float yaw, Function<Boolean, Entity> repositionEntity) {
                entity.func_70029_a((World)world);
                world.func_217447_b((ServerPlayerEntity)entity);
                entity.func_225653_b_(x, y, z);
                entity.func_70634_a(x, y, z);
                return entity;
            }
        });
    }

    private static void facePosition(Entity entity, double newX, double newY, double newZ, BlockPos dest) {
        double d0 = (double)dest.func_177958_n() - newX;
        double d1 = (double)dest.func_177956_o() - (newY + (double)entity.func_70047_e());
        double d2 = (double)dest.func_177952_p() - newZ;
        double d3 = MathHelper.func_76133_a((double)(d0 * d0 + d2 * d2));
        float f = (float)(MathHelper.func_181159_b((double)d2, (double)d0) * 57.29577951308232) - 90.0f;
        float f1 = (float)(-(MathHelper.func_181159_b((double)d1, (double)d3) * 57.29577951308232));
        entity.field_70125_A = TeleportUtils.updateRotation(entity.field_70125_A, f1);
        entity.field_70177_z = TeleportUtils.updateRotation(entity.field_70177_z, f);
    }

    private static float updateRotation(float angle, float targetAngle) {
        float f = MathHelper.func_76142_g((float)(targetAngle - angle));
        return angle + f;
    }

    public static Entity teleportEntity(Entity entity, DimPos pos, @Nullable Direction facing) {
        return TeleportUtils.teleportEntity(entity, (World)pos.getDimensionId().getWorld(), (double)pos.getX() + 0.5, pos.getY(), (double)pos.getZ() + 0.5, facing);
    }

    public static Entity teleportEntity(Entity entity, World destWorld, final double newX, final double newY, final double newZ, final @Nullable Direction facing) {
        World world = entity.func_130014_f_();
        if (DimensionId.fromWorld(world).equals(DimensionId.fromWorld(destWorld))) {
            if (facing != null) {
                TeleportUtils.fixOrientation(entity, newX, newY, newZ, facing);
            }
            entity.func_70012_b(newX, newY, newZ, entity.field_70177_z, entity.field_70125_A);
            ((ServerWorld)destWorld).func_217479_a(entity);
            return entity;
        }
        return entity.changeDimension((ServerWorld)destWorld, new ITeleporter(){

            public Entity placeEntity(Entity entity, ServerWorld currentWorld, ServerWorld destWorld, float yaw, Function<Boolean, Entity> repositionEntity) {
                entity = repositionEntity.apply(false);
                if (facing != null) {
                    TeleportUtils.fixOrientation(entity, newX, newY, newZ, facing);
                }
                entity.func_70634_a(newX, newY, newZ);
                return entity;
            }
        });
    }

    private static void fixOrientation(Entity entity, double newX, double newY, double newZ, Direction facing) {
        if (facing != Direction.DOWN && facing != Direction.UP) {
            TeleportUtils.facePosition(entity, newX, newY, newZ, new BlockPos(newX, newY, newZ).func_177967_a(facing, 4));
        }
    }
}

