/*
 * Decompiled with CFR 0.152.
 */
package com.qsoftware.modlib.silentlib.util;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.qsoftware.modlib.QModLib;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import net.minecraft.nbt.CollectionNBT;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NumberNBT;
import net.minecraft.nbt.StringNBT;

public final class NBTToJson {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();

    private NBTToJson() {
        throw new IllegalAccessError("Utility class");
    }

    public static JsonElement toJson(INBT nbt) {
        if (nbt instanceof CompoundNBT) {
            return NBTToJson.toJsonObject((CompoundNBT)nbt);
        }
        if (nbt instanceof CollectionNBT) {
            return NBTToJson.toJsonArray((CollectionNBT)nbt);
        }
        if (nbt instanceof NumberNBT) {
            return new JsonPrimitive(((NumberNBT)nbt).func_209908_j());
        }
        if (nbt instanceof StringNBT) {
            return new JsonPrimitive(nbt.func_150285_a_());
        }
        return JsonNull.INSTANCE;
    }

    public static JsonObject toJsonObject(CompoundNBT nbt) {
        JsonObject json = new JsonObject();
        for (String key : nbt.func_150296_c()) {
            INBT element = nbt.func_74781_a(key);
            if (element == null) continue;
            json.add(key, NBTToJson.toJson(element));
        }
        return json;
    }

    public static JsonArray toJsonArray(CollectionNBT<?> nbt) {
        JsonArray json = new JsonArray();
        for (INBT element : nbt) {
            json.add(NBTToJson.toJson(element));
        }
        return json;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String writeFile(JsonObject json) {
        DateTimeFormatter dtf = DateTimeFormatter.ofPattern("yyyy-MM-dd_HH-mm-ss");
        LocalDateTime now = LocalDateTime.now();
        String fileName = "nbt_export_" + dtf.format(now) + ".json";
        String dirPath = "output/qmodlib_user";
        File output = new File("output/qmodlib_user", fileName);
        File directory = output.getParentFile();
        if (!directory.exists() && !directory.mkdirs()) {
            QModLib.LOGGER.error("Could not create directory: {}", (Object)output.getParent());
            return "Could not create output directory";
        }
        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(output), StandardCharsets.UTF_8);){
            GSON.toJson((JsonElement)json, (Appendable)writer);
            String absolutePath = output.getAbsolutePath();
            QModLib.LOGGER.info("Wrote model file {}", (Object)absolutePath);
            String string = "Wrote to " + absolutePath;
            return string;
        }
        catch (IOException ex) {
            ex.printStackTrace();
            return ex.toString();
        }
    }
}

