/*
 * Decompiled with CFR 0.152.
 */
package com.qsoftware.modlib.silentlib.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.block.AirBlock;
import net.minecraft.block.Block;
import net.minecraft.loot.LootTableManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.logging.log4j.Logger;

public final class BlockUtils {
    private BlockUtils() {
        throw new IllegalAccessError("Utility class");
    }

    public static Collection<ResourceLocation> getMissingLootTables(String modId, ServerWorld world) {
        LootTableManager lootTableManager = world.func_73046_m().func_200249_aQ();
        ArrayList<ResourceLocation> missing = new ArrayList<ResourceLocation>();
        for (Block block : ForgeRegistries.BLOCKS.getValues()) {
            ResourceLocation lootTable = block.func_220068_i();
            if (!lootTable.func_110624_b().equals(modId) || block instanceof AirBlock || lootTableManager.func_215304_a().contains(lootTable)) continue;
            missing.add(lootTable);
        }
        return missing;
    }

    @Nullable
    public static ITextComponent checkAndReportMissingLootTables(String modId, ServerWorld world, @Nullable Logger logger) {
        LootTableManager lootTableManager = world.func_73046_m().func_200249_aQ();
        Collection<ResourceLocation> missing = BlockUtils.getMissingLootTables(modId, world);
        if (!missing.isEmpty()) {
            if (logger != null) {
                missing.forEach(id -> logger.error("Missing block loot table '{}'", id));
            }
            String list = missing.stream().map(ResourceLocation::toString).collect(Collectors.joining(", "));
            return new StringTextComponent("The following block loot tables are missing: " + list).func_240699_a_(TextFormatting.RED);
        }
        return null;
    }
}

