/*
 * Decompiled with CFR 0.152.
 */
package com.qsoftware.modlib.silentlib.registry;

import com.qsoftware.modlib.silentlib.registry.RegistryObjectWrapper;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.RegistryBuilder;

public class DeferredRegisterWrapper<T extends IForgeRegistryEntry<T>> {
    protected final DeferredRegister<T> internal;

    protected DeferredRegisterWrapper(String modid, IForgeRegistry<T> registry) {
        this.internal = DeferredRegister.create(registry, (String)modid);
    }

    protected DeferredRegisterWrapper(String modid, Class<T> base) {
        this.internal = DeferredRegister.create(base, (String)modid);
    }

    protected <I extends T, W extends RegistryObjectWrapper<I>> W register(String name, Supplier<? extends I> sup, Function<RegistryObject<I>, W> objectWrapper) {
        return (W)((RegistryObjectWrapper)objectWrapper.apply(this.internal.register(name, sup)));
    }

    public void createAndRegister(IEventBus bus, String name) {
        this.internal.makeRegistry(name, RegistryBuilder::new);
        this.register(bus);
    }

    public void createAndRegisterWithTags(IEventBus bus, String name, String tagFolder) {
        this.internal.makeRegistry(name, () -> new RegistryBuilder().tagFolder(tagFolder));
        this.register(bus);
    }

    public void register(IEventBus bus) {
        this.internal.register(bus);
    }
}

