/*
 * Decompiled with CFR 0.152.
 */
package com.qsoftware.modlib.silentlib.network.internal;

import com.qsoftware.modlib.silentlib.client.gui.nbt.DisplayNBTScreen;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.fml.network.NetworkEvent;

public class DisplayNBTPacket {
    private CompoundNBT nbt;
    private ITextComponent title;

    public DisplayNBTPacket() {
    }

    public DisplayNBTPacket(CompoundNBT nbt, ITextComponent title) {
        this.nbt = nbt;
        this.title = title;
    }

    public static DisplayNBTPacket fromBytes(PacketBuffer buffer) {
        DisplayNBTPacket packet = new DisplayNBTPacket();
        packet.nbt = buffer.func_150793_b();
        packet.title = buffer.func_179258_d();
        return packet;
    }

    public void toBytes(PacketBuffer buffer) {
        buffer.func_150786_a(this.nbt);
        buffer.func_179256_a(this.title);
    }

    public static void handle(DisplayNBTPacket packet, Supplier<NetworkEvent.Context> context) {
        ClientWrapper.handle(packet);
        context.get().setPacketHandled(true);
    }

    private static class ClientWrapper {
        private ClientWrapper() {
        }

        private static void handle(DisplayNBTPacket packet) {
            ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
            if (player != null) {
                DisplayNBTScreen screen = new DisplayNBTScreen(packet.nbt, packet.title);
                Minecraft.func_71410_x().func_147108_a((Screen)screen);
            }
        }
    }
}

