/*
 * Decompiled with CFR 0.152.
 */
package com.qsoftware.modlib.silentlib.event;

import com.qsoftware.modlib.QModLib;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedDeque;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;

public final class ServerTicks {
    private static final ServerTicks INSTANCE = new ServerTicks();
    private static final int QUEUE_OVERFLOW_LIMIT = 200;
    private volatile Queue<Runnable> scheduledActions = new ConcurrentLinkedDeque<Runnable>();

    private ServerTicks() {
        MinecraftForge.EVENT_BUS.addListener(this::serverTicks);
    }

    public static void scheduleAction(Runnable action) {
        ServerTicks.INSTANCE.scheduledActions.add(action);
        if (ServerTicks.INSTANCE.scheduledActions.size() > 200) {
            QModLib.LOGGER.warn("Too many server tick actions queued! Currently at {} items. Would have added '{}'.", (Object)ServerTicks.INSTANCE.scheduledActions.size(), (Object)action);
            QModLib.LOGGER.catching((Throwable)new IllegalStateException("ServerTicks queue overflow"));
            ServerTicks.INSTANCE.scheduledActions.clear();
        }
    }

    private void serverTicks(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            this.runScheduledActions();
        }
    }

    private void runScheduledActions() {
        Runnable action = this.scheduledActions.poll();
        while (action != null) {
            action.run();
            action = this.scheduledActions.poll();
        }
    }
}

