/*
 * Decompiled with CFR 0.152.
 */
package com.qsoftware.modlib.silentlib.data;

import com.google.common.collect.Sets;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.qsoftware.modlib.silentlib.util.NameUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.ICriterionInstance;
import net.minecraft.advancements.IRequirementsStrategy;
import net.minecraft.advancements.criterion.EntityPredicate;
import net.minecraft.advancements.criterion.RecipeUnlockedTrigger;
import net.minecraft.data.IFinishedRecipe;
import net.minecraft.item.Item;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.tags.ITag;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;

public class ExtendedShapedRecipeBuilder {
    private final IRecipeSerializer<?> serializer;
    private final Collection<Consumer<JsonObject>> extraData = new ArrayList<Consumer<JsonObject>>();
    private final Item result;
    private final int count;
    private final List<String> pattern = new ArrayList<String>();
    private final Map<Character, Ingredient> key = new LinkedHashMap<Character, Ingredient>();
    private final Advancement.Builder advancementBuilder = Advancement.Builder.func_200278_a();
    private boolean hasAdvancementCriterion = false;
    private String group = "";

    private ExtendedShapedRecipeBuilder(IRecipeSerializer<?> serializer, IItemProvider result, int count) {
        this.serializer = serializer;
        this.result = result.func_199767_j();
        this.count = count;
    }

    public static ExtendedShapedRecipeBuilder builder(IRecipeSerializer<?> serializer, IItemProvider result) {
        return ExtendedShapedRecipeBuilder.builder(serializer, result, 1);
    }

    public static ExtendedShapedRecipeBuilder builder(IRecipeSerializer<?> serializer, IItemProvider result, int count) {
        return new ExtendedShapedRecipeBuilder(serializer, result, count);
    }

    public static ExtendedShapedRecipeBuilder vanillaBuilder(IItemProvider result) {
        return ExtendedShapedRecipeBuilder.vanillaBuilder(result, 1);
    }

    public static ExtendedShapedRecipeBuilder vanillaBuilder(IItemProvider result, int count) {
        return new ExtendedShapedRecipeBuilder(IRecipeSerializer.field_222157_a, result, count);
    }

    protected void serializeExtra(JsonObject json) {
        this.extraData.forEach(consumer -> consumer.accept(json));
    }

    public ExtendedShapedRecipeBuilder addExtraData(Consumer<JsonObject> extraDataIn) {
        this.extraData.add(extraDataIn);
        return this;
    }

    public ExtendedShapedRecipeBuilder key(Character symbol, ITag<Item> tagIn) {
        return this.key(symbol, Ingredient.func_199805_a(tagIn));
    }

    public ExtendedShapedRecipeBuilder key(Character symbol, IItemProvider itemIn) {
        return this.key(symbol, Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{itemIn}));
    }

    public ExtendedShapedRecipeBuilder key(Character symbol, Ingredient ingredientIn) {
        if (this.key.containsKey(symbol)) {
            throw new IllegalArgumentException("Symbol '" + symbol + "' is already defined!");
        }
        if (symbol.charValue() == ' ') {
            throw new IllegalArgumentException("Symbol ' ' (whitespace) is reserved and cannot be defined");
        }
        this.key.put(symbol, ingredientIn);
        return this;
    }

    public ExtendedShapedRecipeBuilder patternLine(String patternIn) {
        if (!this.pattern.isEmpty() && patternIn.length() != this.pattern.get(0).length()) {
            throw new IllegalArgumentException("Pattern must be the same width on every line!");
        }
        this.pattern.add(patternIn);
        return this;
    }

    public ExtendedShapedRecipeBuilder addCriterion(String name, ICriterionInstance criterionIn) {
        this.advancementBuilder.func_200275_a(name, criterionIn);
        this.hasAdvancementCriterion = true;
        return this;
    }

    public ExtendedShapedRecipeBuilder setGroup(String groupIn) {
        this.group = groupIn;
        return this;
    }

    public void build(Consumer<IFinishedRecipe> consumer) {
        this.build(consumer, NameUtils.from(this.result));
    }

    public void build(Consumer<IFinishedRecipe> consumer, ResourceLocation id) {
        this.validate(id);
        if (this.hasAdvancementCriterion && !this.advancementBuilder.func_200277_c().isEmpty()) {
            this.advancementBuilder.func_200272_a(new ResourceLocation("recipes/root")).func_200275_a("has_the_recipe", (ICriterionInstance)new RecipeUnlockedTrigger.Instance(EntityPredicate.AndPredicate.field_234582_a_, id)).func_200271_a(AdvancementRewards.Builder.func_200280_c((ResourceLocation)id)).func_200270_a(IRequirementsStrategy.field_223215_b_);
        }
        ResourceLocation advancementId = new ResourceLocation(id.func_110624_b(), "recipes/" + Objects.requireNonNull(this.result.func_77640_w()).func_200300_c() + "/" + id.func_110623_a());
        consumer.accept(new Result(id, this, advancementId));
    }

    private void validate(ResourceLocation id) {
        if (this.pattern.isEmpty()) {
            throw new IllegalStateException("No pattern is defined for shaped recipe " + id + "!");
        }
        HashSet set = Sets.newHashSet(this.key.keySet());
        set.remove(Character.valueOf(' '));
        for (String s : this.pattern) {
            for (int i = 0; i < s.length(); ++i) {
                char c0 = s.charAt(i);
                if (!this.key.containsKey(Character.valueOf(c0)) && c0 != ' ') {
                    throw new IllegalStateException("Pattern in recipe " + id + " uses undefined symbol '" + c0 + "'");
                }
                set.remove(Character.valueOf(c0));
            }
        }
        if (!set.isEmpty()) {
            throw new IllegalStateException("Ingredients are defined but not used in pattern for recipe " + id);
        }
        if (this.pattern.size() == 1 && this.pattern.get(0).length() == 1) {
            throw new IllegalStateException("Shaped recipe " + id + " only takes in a single item - should it be a shapeless recipe instead?");
        }
    }

    public static class Result
    implements IFinishedRecipe {
        private final ResourceLocation id;
        private final ExtendedShapedRecipeBuilder builder;
        private final ResourceLocation advancementId;

        public Result(ResourceLocation id, ExtendedShapedRecipeBuilder builder, ResourceLocation advancementId) {
            this.id = id;
            this.builder = builder;
            this.advancementId = advancementId;
        }

        public void func_218610_a(JsonObject json) {
            if (!this.builder.group.isEmpty()) {
                json.addProperty("group", this.builder.group);
            }
            JsonArray pattern = new JsonArray();
            this.builder.pattern.forEach(arg_0 -> ((JsonArray)pattern).add(arg_0));
            json.add("pattern", (JsonElement)pattern);
            JsonObject key = new JsonObject();
            this.builder.key.forEach((c, ingredient) -> key.add(String.valueOf(c), ingredient.func_200304_c()));
            json.add("key", (JsonElement)key);
            JsonObject result = new JsonObject();
            result.addProperty("item", NameUtils.from(this.builder.result).toString());
            if (this.builder.count > 1) {
                result.addProperty("count", (Number)this.builder.count);
            }
            json.add("result", (JsonElement)result);
            this.builder.serializeExtra(json);
        }

        public IRecipeSerializer<?> func_218609_c() {
            return this.builder.serializer;
        }

        public ResourceLocation func_200442_b() {
            return this.id;
        }

        @Nullable
        public JsonObject func_200440_c() {
            return this.builder.hasAdvancementCriterion ? this.builder.advancementBuilder.func_200273_b() : null;
        }

        @Nullable
        public ResourceLocation func_200443_d() {
            return this.builder.hasAdvancementCriterion ? this.advancementId : null;
        }
    }
}

