/*
 * Decompiled with CFR 0.152.
 */
package com.qsoftware.modlib.graphics;

import com.google.common.annotations.Beta;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import com.qsoftware.modlib.api.annotations.FieldsAreNonnullByDefault;
import com.qsoftware.modlib.common.geom.RectangleUV;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

@FieldsAreNonnullByDefault
@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
@Beta
public class MCGraphics {
    private final MatrixStack matrixStack;
    private final Minecraft mc;
    private final TextureManager textureManager;
    private final ItemRenderer itemRenderer;
    private FontRenderer font;
    private Color color;

    public MCGraphics(MatrixStack matrixStack, FontRenderer font) {
        this.matrixStack = matrixStack;
        this.font = font;
        this.mc = Minecraft.func_71410_x();
        this.textureManager = this.mc.func_110434_K();
        this.itemRenderer = this.mc.func_175599_af();
    }

    public void drawString(String string, int x, int y) {
        this.drawString(string, x, y, false);
    }

    public void drawString(String string, int x, int y, boolean shadow) {
        if (shadow) {
            this.font.func_238405_a_(this.matrixStack, string, (float)x, (float)y, this.color.getRGB());
        } else {
            this.font.func_238421_b_(this.matrixStack, string, (float)x, (float)y, this.color.getRGB());
        }
    }

    public void drawString(String string, int x, int y, Color color) {
        this.drawString(string, x, y, color, false);
    }

    public void drawString(String string, int x, int y, Color color, boolean shadow) {
        if (shadow) {
            this.font.func_238405_a_(this.matrixStack, string, (float)x, (float)y, color.getRGB());
        } else {
            this.font.func_238421_b_(this.matrixStack, string, (float)x, (float)y, color.getRGB());
        }
    }

    public void drawTexture(Rectangle rect, RectangleUV uv, Dimension textureSize, ResourceLocation resource) {
        this.drawTexture(rect.x, rect.y, rect.width, rect.height, uv.u, uv.v, uv.uWidth, uv.vHeight, textureSize.width, textureSize.height, resource);
    }

    public void drawTexture(Point pos, RectangleUV uv, Dimension textureSize, ResourceLocation resource) {
        this.drawTexture(pos.x, pos.y, uv.u, uv.v, uv.uWidth, uv.vHeight, textureSize.width, textureSize.height, resource);
    }

    public void drawTexture(Point pos, int blitOffset, RectangleUV uv, Dimension textureSize, ResourceLocation resource) {
        this.drawTexture(pos.x, pos.y, blitOffset, uv.u, uv.v, uv.uWidth, uv.vHeight, textureSize.width, textureSize.height, resource);
    }

    public void drawTexture(int x, int y, int width, int height, float uOffset, float vOffset, int uWidth, int vHeight, int textureWidth, int textureHeight, ResourceLocation resource) {
        this.textureManager.func_110577_a(resource);
        Screen.func_238466_a_((MatrixStack)this.matrixStack, (int)x, (int)y, (int)width, (int)height, (float)uOffset, (float)vOffset, (int)uWidth, (int)vHeight, (int)textureWidth, (int)textureHeight);
    }

    public void drawTexture(int x, int y, float uOffset, float vOffset, int uWidth, int vHeight, int textureWidth, int textureHeight, ResourceLocation resource) {
        this.textureManager.func_110577_a(resource);
        Screen.func_238463_a_((MatrixStack)this.matrixStack, (int)x, (int)y, (float)uOffset, (float)vOffset, (int)uWidth, (int)vHeight, (int)textureWidth, (int)textureHeight);
    }

    public void drawTexture(int x, int y, int blitOffset, float uOffset, float vOffset, int uWidth, int vHeight, int textureWidth, int textureHeight, ResourceLocation resource) {
        this.textureManager.func_110577_a(resource);
        Screen.func_238464_a_((MatrixStack)this.matrixStack, (int)x, (int)y, (int)blitOffset, (float)uOffset, (float)vOffset, (int)uWidth, (int)vHeight, (int)textureHeight, (int)textureWidth);
    }

    public final void drawCenteredString(String text, float x, float y, Color color) {
        this.drawCenteredString(text, x, y, color, false);
    }

    public final void drawCenteredString(String text, float x, float y, Color color, boolean shadow) {
        if (shadow) {
            this.font.func_238405_a_(this.matrixStack, text, x - (float)(this.font.func_78256_a(text) / 2), y, color.getRGB());
        } else {
            this.font.func_238421_b_(this.matrixStack, text, x - (float)(this.font.func_78256_a(text) / 2), y, color.getRGB());
        }
    }

    public final void drawItemStack(ItemStack stack, int x, int y, String altText) {
        RenderSystem.translatef((float)0.0f, (float)0.0f, (float)32.0f);
        this.itemRenderer.field_77023_b = 200.0f;
        FontRenderer font = stack.func_77973_b().getFontRenderer(stack);
        if (font == null) {
            font = Minecraft.func_71410_x().field_71466_p;
        }
        if (this.font != null) {
            font = this.font;
        }
        this.itemRenderer.func_180450_b(stack, x, y);
        this.itemRenderer.func_180453_a(font, stack, x, y - (stack.func_190926_b() ? 0 : 8), altText);
        this.itemRenderer.field_77023_b = 0.0f;
    }

    public FontRenderer getFont() {
        return this.font;
    }

    public void setFont(FontRenderer font) {
        this.font = font;
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
    }
}

