/*
 * Decompiled with CFR 0.152.
 */
package com.qsoftware.modlib.common.maps;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class SequencedHashMap<K, V>
implements Map<K, V>,
Cloneable,
Externalizable {
    private static final int KEY = 0;
    private static final int VALUE = 1;
    private static final int ENTRY = 2;
    private static final int REMOVED_MASK = Integer.MIN_VALUE;
    private static final long serialVersionUID = 3380552487888102930L;
    private Entry<K, V> sentinel = SequencedHashMap.createSentinel();
    private HashMap<K, Entry<K, V>> entries;
    private transient long modCount = 0L;

    public SequencedHashMap() {
        this.entries = new HashMap();
    }

    public SequencedHashMap(int initialSize) {
        this.entries = new HashMap(initialSize);
    }

    public SequencedHashMap(int initialSize, float loadFactor) {
        this.entries = new HashMap(initialSize, loadFactor);
    }

    public SequencedHashMap(Map<K, V> m) {
        this();
        this.putAll(m);
    }

    private static <K, V> Entry<K, V> createSentinel() {
        Entry<Object, Object> s = new Entry<Object, Object>(null, null);
        s.prev = s;
        s.next = s;
        return s;
    }

    private void removeEntry(Entry<K, V> entry) {
        entry.next.prev = entry.prev;
        entry.prev.next = entry.next;
    }

    private void insertEntry(Entry<K, V> entry) {
        entry.next = this.sentinel;
        entry.prev = this.sentinel.prev;
        this.sentinel.prev.next = entry;
        this.sentinel.prev = entry;
    }

    @Override
    public int size() {
        return this.entries.size();
    }

    @Override
    public boolean isEmpty() {
        return this.sentinel.next == this.sentinel;
    }

    @Override
    public boolean containsKey(Object key) {
        return this.entries.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        if (value == null) {
            Entry pos = this.sentinel.next;
            while (pos != this.sentinel) {
                if (pos.getValue() == null) {
                    return true;
                }
                pos = pos.next;
            }
        } else {
            Entry pos = this.sentinel.next;
            while (pos != this.sentinel) {
                if (value.equals(pos.getValue())) {
                    return true;
                }
                pos = pos.next;
            }
        }
        return false;
    }

    @Override
    public V get(Object o) {
        Entry<K, V> entry = this.entries.get(o);
        if (entry == null) {
            return null;
        }
        return entry.getValue();
    }

    public Map.Entry<K, V> getFirst() {
        return this.isEmpty() ? null : this.sentinel.next;
    }

    public Object getFirstKey() {
        return this.sentinel.next.getKey();
    }

    public Object getFirstValue() {
        return this.sentinel.next.getValue();
    }

    public Map.Entry<K, V> getLast() {
        return this.isEmpty() ? null : this.sentinel.prev;
    }

    public Object getLastKey() {
        return this.sentinel.prev.getKey();
    }

    public Object getLastValue() {
        return this.sentinel.prev.getValue();
    }

    @Override
    public V put(K key, V value) {
        ++this.modCount;
        V oldValue = null;
        Entry<K, V> e = this.entries.get(key);
        if (e != null) {
            this.removeEntry(e);
            oldValue = e.setValue(value);
        } else {
            e = new Entry<K, V>(key, value);
            this.entries.put(key, e);
        }
        this.insertEntry(e);
        return oldValue;
    }

    @Override
    public V remove(Object key) {
        Entry<Object, V> e = this.removeImpl(key);
        return e == null ? null : (V)e.getValue();
    }

    private Entry<K, V> removeImpl(K key) {
        Entry<K, V> e = this.entries.remove(key);
        if (e == null) {
            return null;
        }
        ++this.modCount;
        this.removeEntry(e);
        return e;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> t) {
        for (Map.Entry<K, V> entry : t.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public void clear() {
        ++this.modCount;
        this.entries.clear();
        this.sentinel.next = this.sentinel;
        this.sentinel.prev = this.sentinel;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Map)) {
            return false;
        }
        return this.entrySet().equals(((Map)obj).entrySet());
    }

    @Override
    public int hashCode() {
        return this.entrySet().hashCode();
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append('[');
        Entry pos = this.sentinel.next;
        while (pos != this.sentinel) {
            buf.append(pos.getKey());
            buf.append('=');
            buf.append(pos.getValue());
            if (pos.next != this.sentinel) {
                buf.append(',');
            }
            pos = pos.next;
        }
        buf.append(']');
        return buf.toString();
    }

    @Override
    @NotNull
    public Set<K> keySet() {
        return new AbstractSet<K>(){

            @Override
            @NotNull
            public Iterator<K> iterator() {
                return new OrderedIterator(0);
            }

            @Override
            public boolean remove(Object o) {
                Entry e = SequencedHashMap.this.removeImpl(o);
                return e != null;
            }

            @Override
            public void clear() {
                SequencedHashMap.this.clear();
            }

            @Override
            public int size() {
                return SequencedHashMap.this.size();
            }

            @Override
            public boolean isEmpty() {
                return SequencedHashMap.this.isEmpty();
            }

            @Override
            public boolean contains(Object o) {
                return SequencedHashMap.this.containsKey(o);
            }
        };
    }

    @Override
    @NotNull
    public Collection<V> values() {
        return new AbstractCollection<V>(){

            @Override
            @NotNull
            public Iterator<V> iterator() {
                return new OrderedIterator(1);
            }

            @Override
            public boolean remove(Object value) {
                if (value == null) {
                    Entry pos = ((SequencedHashMap)SequencedHashMap.this).sentinel.next;
                    while (pos != SequencedHashMap.this.sentinel) {
                        if (pos.getValue() == null) {
                            SequencedHashMap.this.removeImpl(pos.getKey());
                            return true;
                        }
                        pos = pos.next;
                    }
                } else {
                    Entry pos = ((SequencedHashMap)SequencedHashMap.this).sentinel.next;
                    while (pos != SequencedHashMap.this.sentinel) {
                        if (value.equals(pos.getValue())) {
                            SequencedHashMap.this.removeImpl(pos.getKey());
                            return true;
                        }
                        pos = pos.next;
                    }
                }
                return false;
            }

            @Override
            public void clear() {
                SequencedHashMap.this.clear();
            }

            @Override
            public int size() {
                return SequencedHashMap.this.size();
            }

            @Override
            public boolean isEmpty() {
                return SequencedHashMap.this.isEmpty();
            }

            @Override
            public boolean contains(Object o) {
                return SequencedHashMap.this.containsValue(o);
            }
        };
    }

    @Override
    @NotNull
    public Set<Map.Entry<K, V>> entrySet() {
        return new AbstractSet<Map.Entry<K, V>>(){

            private Entry<K, V> findEntry(Map.Entry<K, V> o) {
                if (o == null) {
                    return null;
                }
                Entry entry = (Entry)SequencedHashMap.this.entries.get(o.getKey());
                if (entry != null && entry.equals(o)) {
                    return entry;
                }
                return null;
            }

            @Override
            @NotNull
            public Iterator<Map.Entry<K, V>> iterator() {
                return new OrderedIterator(2);
            }

            @Override
            public boolean remove(Object o) {
                if (!(o instanceof Map.Entry)) {
                    throw new ClassCastException("Cannot cast " + o.getClass().getSimpleName() + " to Map.Entry");
                }
                Entry e = this.findEntry((Map.Entry)o);
                if (e == null) {
                    return false;
                }
                return SequencedHashMap.this.removeImpl(e.getKey()) != null;
            }

            @Override
            public void clear() {
                SequencedHashMap.this.clear();
            }

            @Override
            public int size() {
                return SequencedHashMap.this.size();
            }

            @Override
            public boolean isEmpty() {
                return SequencedHashMap.this.isEmpty();
            }

            @Override
            public boolean contains(Object o) {
                if (!(o instanceof Map.Entry)) {
                    throw new ClassCastException("Cannot cast " + o.getClass().getSimpleName() + " to Map.Entry");
                }
                return this.findEntry((Map.Entry)o) != null;
            }
        };
    }

    public SequencedHashMap<K, V> clone() throws CloneNotSupportedException {
        SequencedHashMap map = (SequencedHashMap)super.clone();
        map.sentinel = SequencedHashMap.createSentinel();
        map.entries = new HashMap();
        map.putAll(this);
        return map;
    }

    private Map.Entry<K, V> getEntry(int index) {
        int i;
        Entry<K, V> pos = this.sentinel;
        if (index < 0) {
            throw new ArrayIndexOutOfBoundsException(index + " < 0");
        }
        for (i = -1; i < index - 1 && pos.next != this.sentinel; ++i) {
            pos = pos.next;
        }
        if (pos.next == this.sentinel) {
            throw new ArrayIndexOutOfBoundsException(index + " >= " + (i + 1));
        }
        return pos.next;
    }

    public Object get(int index) {
        return this.getEntry(index).getKey();
    }

    public Object getValue(int index) {
        return this.getEntry(index).getValue();
    }

    public int indexOf(K key) {
        Entry<K, V> e = this.entries.get(key);
        int pos = 0;
        while (e.prev != this.sentinel) {
            ++pos;
            e = e.prev;
        }
        return pos;
    }

    public Iterator<K> iterator() {
        return this.keySet().iterator();
    }

    public int lastIndexOf(K key) {
        return this.indexOf(key);
    }

    public List<K> sequence() {
        ArrayList<K> l = new ArrayList<K>(this.size());
        l.addAll(this.keySet());
        return Collections.unmodifiableList(l);
    }

    public Object remove(int index) {
        return this.remove(this.get(index));
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException, ClassCastException {
        int size = in.readInt();
        for (int i = 0; i < size; ++i) {
            Object key = in.readObject();
            Object value = in.readObject();
            this.put(key, value);
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.size());
        Entry pos = this.sentinel.next;
        while (pos != this.sentinel) {
            out.writeObject(pos.getKey());
            out.writeObject(pos.getValue());
            pos = pos.next;
        }
    }

    private class OrderedIterator<T>
    implements Iterator<T> {
        private int returnType;
        private Entry<K, V> pos;
        private transient long expectedModCount;

        public OrderedIterator(int returnType) {
            this.pos = SequencedHashMap.this.sentinel;
            this.expectedModCount = SequencedHashMap.this.modCount;
            this.returnType = returnType | Integer.MIN_VALUE;
        }

        @Override
        public boolean hasNext() {
            return this.pos.next != SequencedHashMap.this.sentinel;
        }

        @Override
        public T next() {
            if (SequencedHashMap.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            if (this.pos.next == SequencedHashMap.this.sentinel) {
                throw new NoSuchElementException();
            }
            this.returnType &= Integer.MAX_VALUE;
            this.pos = this.pos.next;
            switch (this.returnType) {
                case 0: {
                    return (T)this.pos.getKey();
                }
                case 1: {
                    return (T)this.pos.getValue();
                }
                case 2: {
                    return (T)this.pos;
                }
            }
            throw new Error("bad iterator type: " + this.returnType);
        }

        @Override
        public void remove() {
            if ((this.returnType & Integer.MIN_VALUE) != 0) {
                throw new IllegalStateException("remove() must follow next()");
            }
            if (SequencedHashMap.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            SequencedHashMap.this.removeImpl(this.pos.getKey());
            ++this.expectedModCount;
            this.returnType |= Integer.MIN_VALUE;
        }
    }

    private static class Entry<K, V>
    implements Map.Entry<K, V> {
        private final K key;
        Entry<K, V> next = null;
        Entry<K, V> prev = null;
        private V value;

        public Entry(K key, V value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public V setValue(V value) {
            V oldValue = this.value;
            this.value = value;
            return oldValue;
        }

        @Override
        public int hashCode() {
            return (this.getKey() == null ? 0 : this.getKey().hashCode()) ^ (this.getValue() == null ? 0 : this.getValue().hashCode());
        }

        public boolean equals(Map.Entry<K, V> obj) {
            if (obj == null) {
                return false;
            }
            if (obj == this) {
                return true;
            }
            return (this.getKey() == null ? obj.getKey() == null : this.getKey().equals(obj.getKey())) && (this.getValue() == null ? obj.getValue() == null : this.getValue().equals(obj.getValue()));
        }

        public String toString() {
            return "[" + this.getKey() + '=' + this.getValue() + ']';
        }
    }
}

