/*
 * Decompiled with CFR 0.152.
 */
package com.qsoftware.modlib.common.geom;

import java.awt.geom.Rectangle2D;
import java.io.Serializable;

public class RectangleUV
extends Rectangle2D
implements Serializable {
    public float u;
    public float v;
    public int uWidth;
    public int vHeight;

    public RectangleUV(float u, float v, int uWidth, int vHeight) {
        this.u = u;
        this.v = v;
        this.uWidth = uWidth;
        this.vHeight = vHeight;
    }

    @Override
    public void setRect(double u, double v, double w, double h) {
        this.u = (float)u;
        this.v = (float)v;
        this.uWidth = (int)w;
        this.vHeight = (int)h;
    }

    @Override
    public int outcode(double u, double v) {
        int out = 0;
        if (this.uWidth <= 0) {
            out |= 5;
        } else if (u < (double)this.u) {
            out |= 1;
        } else if (u > (double)(this.u + (float)this.uWidth)) {
            out |= 4;
        }
        if (this.vHeight <= 0) {
            out |= 0xA;
        } else if (v < (double)this.v) {
            out |= 2;
        } else if (v > (double)(this.v + (float)this.vHeight)) {
            out |= 8;
        }
        return out;
    }

    @Override
    public Rectangle2D getBounds2D() {
        return new Rectangle2D.Float(this.u, this.v, this.uWidth, this.vHeight);
    }

    @Override
    public Rectangle2D createIntersection(Rectangle2D r) {
        Rectangle2D.Double dest = new Rectangle2D.Double();
        Rectangle2D.intersect(this, r, dest);
        return dest;
    }

    @Override
    public Rectangle2D createUnion(Rectangle2D r) {
        Rectangle2D.Double dest = new Rectangle2D.Double();
        Rectangle2D.union(this, r, dest);
        return dest;
    }

    @Override
    public double getX() {
        return this.u;
    }

    @Override
    public double getY() {
        return this.v;
    }

    @Override
    public double getWidth() {
        return this.uWidth;
    }

    @Override
    public double getHeight() {
        return this.vHeight;
    }

    @Override
    public boolean isEmpty() {
        return this.uWidth == 0 && this.vHeight == 0;
    }
}

