/*
 * Decompiled with CFR 0.152.
 */
package com.qsoftware.modlib.common;

import com.qsoftware.modlib.api.annotations.FieldsAreNonnullByDefault;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import org.jetbrains.annotations.NotNull;

@FieldsAreNonnullByDefault
@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class Ticker {
    private int ticks;
    private final Predicate<Ticker> autoReset;
    private final Consumer<Ticker> onTick;

    public Ticker(int startValue) {
        this(startValue, ticker -> false);
    }

    public Ticker(int startValue, @NotNull Predicate<Ticker> autoReset) {
        this(startValue, autoReset, ticker -> {});
    }

    public Ticker(int startValue, @NotNull Predicate<Ticker> autoReset, @NotNull Consumer<Ticker> onTick) {
        this.ticks = startValue;
        this.autoReset = autoReset;
        this.onTick = onTick;
    }

    public void advance() {
        ++this.ticks;
        this.onTick.accept(this);
        if (this.autoReset.test(this)) {
            this.reset();
        }
    }

    public void reset() {
        this.ticks = 0;
    }

    public int getTicks() {
        return this.ticks;
    }
}

