/*
 * Decompiled with CFR 0.152.
 */
package com.qsoftware.modlib.common;

import com.qsoftware.modlib.api.annotations.FieldsAreNonnullByDefault;
import com.qsoftware.modlib.common.Percentage;
import com.qsoftware.modlib.common.interfaces.Formattable;
import com.qsoftware.modlib.utils.helpers.MathHelper;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.util.text.TextFormatting;

@FieldsAreNonnullByDefault
@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class Multiplier
implements Formattable {
    private final double value;

    public Multiplier(double value) {
        this.value = value;
    }

    @Override
    public String toFormattedString() {
        if (MathHelper.getDecimalPlaces(this.value) == 0) {
            return TextFormatting.GOLD.toString() + Math.round(this.value) + TextFormatting.GRAY + "x";
        }
        return TextFormatting.GOLD.toString() + this.value + TextFormatting.GRAY + "x";
    }

    public double getValue() {
        return this.value;
    }

    public Percentage toPercentage() {
        return new Percentage(this.value);
    }
}

