/*
 * Decompiled with CFR 0.152.
 */
package com.qsoftware.modlib.api.tier;

import com.qsoftware.modlib.api.math.MathUtils;
import com.qsoftware.modlib.api.text.EnumColor;
import java.util.Locale;
import net.minecraft.util.IStringSerializable;

public enum BaseTier implements IStringSerializable
{
    BASIC("Basic", EnumColor.BRIGHT_GREEN, EnumColor.BRIGHT_GREEN),
    ADVANCED("Advanced", EnumColor.DARK_RED, EnumColor.RED),
    ELITE("Elite", EnumColor.INDIGO, EnumColor.INDIGO),
    ULTIMATE("Ultimate", EnumColor.PURPLE, EnumColor.PURPLE),
    CREATIVE("Creative", EnumColor.BLACK, EnumColor.DARK_GRAY);

    private static final BaseTier[] TIERS;
    private final String name;
    private final EnumColor color;
    private final EnumColor textColor;

    private BaseTier(String s, EnumColor c, EnumColor c1) {
        this.name = s;
        this.color = c;
        this.textColor = c1;
    }

    public static BaseTier byIndexStatic(int index) {
        return MathUtils.getByIndexMod(TIERS, index);
    }

    public String getSimpleName() {
        return this.name;
    }

    public String getLowerName() {
        return this.getSimpleName().toLowerCase(Locale.ROOT);
    }

    public EnumColor getColor() {
        return this.color;
    }

    public EnumColor getTextColor() {
        return this.textColor;
    }

    public String func_176610_l() {
        return this.name().toLowerCase(Locale.ROOT);
    }

    static {
        TIERS = BaseTier.values();
    }
}

