/*
 * Decompiled with CFR 0.152.
 */
package com.qsoftware.modlib.api.text;

import com.qsoftware.modlib.api.IIncrementalEnum;
import com.qsoftware.modlib.api.math.MathUtils;
import com.qsoftware.modlib.api.text.APILang;
import com.qsoftware.modlib.api.text.TextComponentUtil;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.item.DyeColor;
import net.minecraft.item.Item;
import net.minecraft.tags.ITag;
import net.minecraft.util.text.Color;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.common.Tags;

public enum EnumColor implements IIncrementalEnum<EnumColor>
{
    BLACK("\u00a70", APILang.COLOR_BLACK, "Black", "Black", "black", new int[]{64, 64, 64}, DyeColor.BLACK),
    DARK_BLUE("\u00a71", APILang.COLOR_DARK_BLUE, "Blue", "Blue", "blue", new int[]{54, 107, 208}, DyeColor.BLUE),
    DARK_GREEN("\u00a72", APILang.COLOR_DARK_GREEN, "Green", "Green", "green", new int[]{89, 193, 95}, DyeColor.GREEN),
    DARK_AQUA("\u00a73", APILang.COLOR_DARK_AQUA, "Cyan", "Cyan", "cyan", new int[]{0, 243, 208}, DyeColor.CYAN),
    DARK_RED("\u00a74", APILang.COLOR_DARK_RED, "Dark Red", null, "dark_red", new int[]{201, 7, 31}, MaterialColor.field_151655_K, (ITag<Item>)Tags.Items.DYES_RED),
    PURPLE("\u00a75", APILang.COLOR_PURPLE, "Purple", "Purple", "purple", new int[]{164, 96, 217}, DyeColor.PURPLE),
    ORANGE("\u00a76", APILang.COLOR_ORANGE, "Orange", "Orange", "orange", new int[]{255, 161, 96}, DyeColor.ORANGE),
    GRAY("\u00a77", APILang.COLOR_GRAY, "Light Gray", "LightGray", "light_gray", new int[]{207, 207, 207}, DyeColor.LIGHT_GRAY),
    DARK_GRAY("\u00a78", APILang.COLOR_DARK_GRAY, "Gray", "Gray", "gray", new int[]{122, 122, 122}, DyeColor.GRAY),
    INDIGO("\u00a79", APILang.COLOR_INDIGO, "Light Blue", "LightBlue", "light_blue", new int[]{85, 158, 255}, DyeColor.LIGHT_BLUE),
    BRIGHT_GREEN("\u00a7a", APILang.COLOR_BRIGHT_GREEN, "Lime", "Lime", "lime", new int[]{117, 255, 137}, DyeColor.LIME),
    AQUA("\u00a7b", APILang.COLOR_AQUA, "Aqua", null, "aqua", new int[]{48, 255, 249}, MaterialColor.field_151674_s, (ITag<Item>)Tags.Items.DYES_LIGHT_BLUE),
    RED("\u00a7c", APILang.COLOR_RED, "Red", "Red", "red", new int[]{255, 56, 60}, DyeColor.RED),
    PINK("\u00a7d", APILang.COLOR_PINK, "Magenta", "Magenta", "magenta", new int[]{213, 94, 203}, DyeColor.MAGENTA),
    YELLOW("\u00a7e", APILang.COLOR_YELLOW, "Yellow", "Yellow", "yellow", new int[]{255, 221, 79}, DyeColor.YELLOW),
    WHITE("\u00a7f", APILang.COLOR_WHITE, "White", "White", "white", new int[]{255, 255, 255}, DyeColor.WHITE),
    BROWN("\u00a76", APILang.COLOR_BROWN, "Brown", "Brown", "brown", new int[]{161, 118, 73}, DyeColor.BROWN),
    BRIGHT_PINK("\u00a7d", APILang.COLOR_BRIGHT_PINK, "Pink", "Pink", "pink", new int[]{255, 188, 196}, DyeColor.PINK);

    private static final EnumColor[] COLORS;
    public final String code;
    private final APILang langEntry;
    private final String englishName;
    private final String registryPrefix;
    @Nullable
    private final String dyeName;
    private final MaterialColor mapColor;
    private final ITag<Item> dyeTag;
    private int[] rgbCode;
    private Color color;

    private EnumColor(String s, @Nullable APILang langEntry, String englishName, String dyeName, String registryPrefix, int[] rgbCode, DyeColor dyeColor) {
        this(s, langEntry, englishName, dyeName, registryPrefix, rgbCode, dyeColor.func_196055_e(), (ITag<Item>)dyeColor.getTag());
    }

    private EnumColor(String code, @Nullable APILang langEntry, String englishName, String dyeName, String registryPrefix, int[] rgbCode, MaterialColor mapColor, ITag<Item> dyeTag) {
        this.code = code;
        this.langEntry = langEntry;
        this.englishName = englishName;
        this.dyeName = dyeName;
        this.registryPrefix = registryPrefix;
        this.setColorFromAtlas(rgbCode);
        this.mapColor = mapColor;
        this.dyeTag = dyeTag;
    }

    public static EnumColor byIndexStatic(int index) {
        return MathUtils.getByIndexMod(COLORS, index);
    }

    public String getRegistryPrefix() {
        return this.registryPrefix;
    }

    public String getEnglishName() {
        return this.englishName;
    }

    public MaterialColor getMapColor() {
        return this.mapColor;
    }

    public ITag<Item> getDyeTag() {
        return this.dyeTag;
    }

    public boolean hasDyeName() {
        return this.dyeName != null;
    }

    public ITextComponent getColoredName() {
        return TextComponentUtil.build(this, this.getName());
    }

    public IFormattableTextComponent getName() {
        return new TranslationTextComponent(this.langEntry.getTranslationKey());
    }

    public APILang getLangEntry() {
        return this.langEntry;
    }

    public float getColor(int index) {
        return (float)this.rgbCode[index] / 255.0f;
    }

    public Color getColor() {
        return this.color;
    }

    public String toString() {
        return this.code;
    }

    @Override
    @Nonnull
    public EnumColor byIndex(int index) {
        return EnumColor.byIndexStatic(index);
    }

    public void setColorFromAtlas(int[] color) {
        this.rgbCode = color;
        this.color = Color.func_240743_a_((int)(this.rgbCode[0] << 16 | this.rgbCode[1] << 8 | this.rgbCode[2]));
    }

    public int[] getRgbCode() {
        return this.rgbCode;
    }

    public float[] getRgbCodeFloat() {
        return new float[]{this.getColor(0), this.getColor(1), this.getColor(2)};
    }

    static {
        COLORS = EnumColor.values();
    }
}

