/*
 * Decompiled with CFR 0.152.
 */
package com.qsoftware.modlib.api.recipes.outputs;

import com.qsoftware.modlib.api.Action;
import com.qsoftware.modlib.api.annotations.NonNull;
import com.qsoftware.modlib.api.chemical.ChemicalStack;
import com.qsoftware.modlib.api.chemical.IChemicalTank;
import com.qsoftware.modlib.api.chemical.gas.GasStack;
import com.qsoftware.modlib.api.chemical.gas.IGasTank;
import com.qsoftware.modlib.api.fluid.IExtendedFluidTank;
import com.qsoftware.modlib.api.inventory.AutomationType;
import com.qsoftware.modlib.api.inventory.IInventorySlot;
import com.qsoftware.modlib.api.math.MathUtils;
import com.qsoftware.modlib.api.recipes.SawmillRecipe;
import com.qsoftware.modlib.api.recipes.outputs.IOutputHandler;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import org.apache.commons.lang3.tuple.Pair;

@ParametersAreNonnullByDefault
public class OutputHelper {
    private OutputHelper() {
    }

    public static <STACK extends ChemicalStack<?>> IOutputHandler<@NonNull STACK> getOutputHandler(final IChemicalTank<?, STACK> tank) {
        return new IOutputHandler<STACK>(){

            @Override
            public void handleOutput(@Nonnull STACK toOutput, int operations) {
                OutputHelper.handleOutput(tank, toOutput, operations);
            }

            @Override
            public int operationsRoomFor(@Nonnull STACK toOutput, int currentMax) {
                return OutputHelper.operationsRoomFor(tank, toOutput, currentMax);
            }
        };
    }

    public static IOutputHandler<@NonNull FluidStack> getOutputHandler(final IExtendedFluidTank fluidTank) {
        return new IOutputHandler<FluidStack>(){

            @Override
            public void handleOutput(@Nonnull FluidStack toOutput, int operations) {
                OutputHelper.handleOutput(fluidTank, toOutput, operations);
            }

            @Override
            public int operationsRoomFor(@Nonnull FluidStack toOutput, int currentMax) {
                return OutputHelper.operationsRoomFor(fluidTank, toOutput, currentMax);
            }
        };
    }

    public static IOutputHandler<@NonNull ItemStack> getOutputHandler(final IInventorySlot inventorySlot) {
        return new IOutputHandler<ItemStack>(){

            @Override
            public void handleOutput(@Nonnull ItemStack toOutput, int operations) {
                OutputHelper.handleOutput(inventorySlot, toOutput, operations);
            }

            @Override
            public int operationsRoomFor(@Nonnull ItemStack toOutput, int currentMax) {
                return OutputHelper.operationsRoomFor(inventorySlot, toOutput, currentMax);
            }
        };
    }

    public static IOutputHandler<@NonNull SawmillRecipe.ChanceOutput> getOutputHandler(final IInventorySlot mainSlot, final IInventorySlot secondarySlot) {
        return new IOutputHandler<SawmillRecipe.ChanceOutput>(){

            @Override
            public void handleOutput(@Nonnull SawmillRecipe.ChanceOutput toOutput, int operations) {
                OutputHelper.handleOutput(mainSlot, toOutput.getMainOutput(), operations);
                ItemStack secondaryOutput = toOutput.getSecondaryOutput();
                for (int i = 0; i < operations; ++i) {
                    OutputHelper.handleOutput(secondarySlot, secondaryOutput, operations);
                    if (i + 1 >= operations) continue;
                    secondaryOutput = toOutput.nextSecondaryOutput();
                }
            }

            @Override
            public int operationsRoomFor(@Nonnull SawmillRecipe.ChanceOutput toOutput, int currentMax) {
                currentMax = OutputHelper.operationsRoomFor(mainSlot, toOutput.getMainOutput(), currentMax);
                return OutputHelper.operationsRoomFor(secondarySlot, toOutput.getMaxSecondaryOutput(), currentMax);
            }
        };
    }

    public static IOutputHandler<@NonNull Pair<@NonNull ItemStack, @NonNull GasStack>> getOutputHandler(final IGasTank gasTank, final IInventorySlot inventorySlot) {
        return new IOutputHandler<Pair<ItemStack, GasStack>>(){

            @Override
            public void handleOutput(@Nonnull Pair<@NonNull ItemStack, @NonNull GasStack> toOutput, int operations) {
                OutputHelper.handleOutput(inventorySlot, toOutput.getLeft(), operations);
                OutputHelper.handleOutput(gasTank, (ChemicalStack)toOutput.getRight(), operations);
            }

            @Override
            public int operationsRoomFor(@Nonnull Pair<@NonNull ItemStack, @NonNull GasStack> toOutput, int currentMax) {
                currentMax = OutputHelper.operationsRoomFor(inventorySlot, toOutput.getLeft(), currentMax);
                return OutputHelper.operationsRoomFor(gasTank, (ChemicalStack)toOutput.getRight(), currentMax);
            }
        };
    }

    public static IOutputHandler<@NonNull Pair<@NonNull GasStack, @NonNull GasStack>> getOutputHandler(final IGasTank leftTank, final IGasTank rightTank) {
        return new IOutputHandler<Pair<GasStack, GasStack>>(){

            @Override
            public void handleOutput(@Nonnull Pair<@NonNull GasStack, @NonNull GasStack> toOutput, int operations) {
                OutputHelper.handleOutput(leftTank, (ChemicalStack)toOutput.getLeft(), operations);
                OutputHelper.handleOutput(rightTank, (ChemicalStack)toOutput.getRight(), operations);
            }

            @Override
            public int operationsRoomFor(@Nonnull Pair<@NonNull GasStack, @NonNull GasStack> toOutput, int currentMax) {
                currentMax = OutputHelper.operationsRoomFor(leftTank, (ChemicalStack)toOutput.getLeft(), currentMax);
                return OutputHelper.operationsRoomFor(rightTank, (ChemicalStack)toOutput.getRight(), currentMax);
            }
        };
    }

    public static <STACK extends ChemicalStack<?>> void handleOutput(IChemicalTank<?, STACK> tank, STACK toOutput, int operations) {
        if (operations == 0) {
            return;
        }
        STACK output = tank.createStack(toOutput, toOutput.getAmount() * (long)operations);
        tank.insert(output, Action.EXECUTE, AutomationType.INTERNAL);
    }

    private static void handleOutput(IExtendedFluidTank fluidTank, FluidStack toOutput, int operations) {
        if (operations == 0) {
            return;
        }
        fluidTank.insert(new FluidStack(toOutput, toOutput.getAmount() * operations), Action.EXECUTE, AutomationType.INTERNAL);
    }

    private static void handleOutput(IInventorySlot inventorySlot, ItemStack toOutput, int operations) {
        if (operations == 0 || toOutput.func_190926_b()) {
            return;
        }
        ItemStack output = toOutput.func_77946_l();
        if (operations > 1) {
            output.func_190920_e(output.func_190916_E() * operations);
        }
        inventorySlot.insertItem(output, Action.EXECUTE, AutomationType.INTERNAL);
    }

    public static <STACK extends ChemicalStack<?>> int operationsRoomFor(IChemicalTank<?, STACK> tank, STACK toOutput, int currentMax) {
        if (currentMax <= 0 || toOutput.isEmpty()) {
            return currentMax;
        }
        STACK maxOutput = tank.createStack(toOutput, Long.MAX_VALUE);
        STACK remainder = tank.insert(maxOutput, Action.SIMULATE, AutomationType.INTERNAL);
        long amountUsed = ((ChemicalStack)maxOutput).getAmount() - ((ChemicalStack)remainder).getAmount();
        return Math.min(MathUtils.clampToInt(amountUsed / toOutput.getAmount()), currentMax);
    }

    private static int operationsRoomFor(IExtendedFluidTank fluidTank, FluidStack toOutput, int currentMax) {
        if (currentMax <= 0 || toOutput.isEmpty()) {
            return currentMax;
        }
        FluidStack maxOutput = new FluidStack(toOutput, Integer.MAX_VALUE);
        FluidStack remainder = fluidTank.insert(maxOutput, Action.SIMULATE, AutomationType.INTERNAL);
        int amountUsed = maxOutput.getAmount() - remainder.getAmount();
        return Math.min(amountUsed / toOutput.getAmount(), currentMax);
    }

    private static int operationsRoomFor(IInventorySlot inventorySlot, ItemStack toOutput, int currentMax) {
        if (currentMax <= 0 || toOutput.func_190926_b()) {
            return currentMax;
        }
        ItemStack output = toOutput.func_77946_l();
        output.func_190920_e(output.func_77976_d());
        ItemStack remainder = inventorySlot.insertItem(output, Action.SIMULATE, AutomationType.INTERNAL);
        int amountUsed = output.func_190916_E() - remainder.func_190916_E();
        return Math.min(amountUsed / toOutput.func_190916_E(), currentMax);
    }
}

