/*
 * Decompiled with CFR 0.152.
 */
package com.qsoftware.modlib.api.recipes.outputs;

import com.qsoftware.modlib.api.chemical.ChemicalStack;
import com.qsoftware.modlib.api.chemical.IChemicalTank;
import com.qsoftware.modlib.api.chemical.merged.BoxedChemicalStack;
import com.qsoftware.modlib.api.chemical.merged.MergedChemicalTank;
import com.qsoftware.modlib.api.recipes.outputs.OutputHelper;
import java.util.Objects;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class BoxedChemicalOutputHandler {
    private final MergedChemicalTank chemicalTank;

    public BoxedChemicalOutputHandler(MergedChemicalTank chemicalTank) {
        this.chemicalTank = Objects.requireNonNull(chemicalTank);
    }

    public void handleOutput(BoxedChemicalStack toOutput, int operations) {
        this.handleOutput(this.chemicalTank.getTankForType(toOutput.getChemicalType()), toOutput.getChemicalStack(), operations);
    }

    private <STACK extends ChemicalStack<?>> void handleOutput(IChemicalTank<?, ?> tank, STACK stack, int operations) {
        OutputHelper.handleOutput(tank, stack, operations);
    }

    public int operationsRoomFor(BoxedChemicalStack toOutput, int currentMax) {
        return this.operationsRoomFor(this.chemicalTank.getTankForType(toOutput.getChemicalType()), toOutput.getChemicalStack(), currentMax);
    }

    private <STACK extends ChemicalStack<?>> int operationsRoomFor(IChemicalTank<?, ?> tank, STACK stack, int currentMax) {
        return OutputHelper.operationsRoomFor(tank, stack, currentMax);
    }
}

