/*
 * Decompiled with CFR 0.152.
 */
package com.qsoftware.modlib.api.recipes.inputs.chemical;

import com.google.gson.JsonElement;
import com.qsoftware.modlib.api.chemical.gas.Gas;
import com.qsoftware.modlib.api.chemical.gas.GasStack;
import com.qsoftware.modlib.api.providers.IGasProvider;
import com.qsoftware.modlib.api.recipes.inputs.chemical.ChemicalIngredientDeserializer;
import com.qsoftware.modlib.api.recipes.inputs.chemical.ChemicalIngredientInfo;
import com.qsoftware.modlib.api.recipes.inputs.chemical.ChemicalStackIngredient;
import com.qsoftware.modlib.api.recipes.inputs.chemical.IChemicalStackIngredient;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tags.ITag;

public interface GasStackIngredient
extends IChemicalStackIngredient<Gas, GasStack> {
    public static GasStackIngredient from(@Nonnull GasStack instance) {
        return GasStackIngredient.from((IGasProvider)instance.getType(), instance.getAmount());
    }

    public static GasStackIngredient from(@Nonnull IGasProvider gas, long amount) {
        return new Single(gas.getStack(amount));
    }

    public static GasStackIngredient from(@Nonnull ITag<Gas> tag, long amount) {
        return new Tagged(tag, amount);
    }

    public static GasStackIngredient read(PacketBuffer buffer) {
        return ChemicalIngredientDeserializer.GAS.read(buffer);
    }

    public static GasStackIngredient deserialize(@Nullable JsonElement json) {
        return ChemicalIngredientDeserializer.GAS.deserialize(json);
    }

    public static GasStackIngredient createMulti(GasStackIngredient ... ingredients) {
        return (GasStackIngredient)ChemicalIngredientDeserializer.GAS.createMulti(ingredients);
    }

    @Override
    default public ChemicalIngredientInfo<Gas, GasStack> getIngredientInfo() {
        return ChemicalIngredientInfo.GAS;
    }

    public static class Multi
    extends ChemicalStackIngredient.MultiIngredient<Gas, GasStack, GasStackIngredient>
    implements GasStackIngredient {
        protected Multi(GasStackIngredient ... ingredients) {
            super((IChemicalStackIngredient[])ingredients);
        }
    }

    public static class Tagged
    extends ChemicalStackIngredient.TaggedIngredient<Gas, GasStack>
    implements GasStackIngredient {
        protected Tagged(@Nonnull ITag<Gas> tag, long amount) {
            super(tag, amount);
        }
    }

    public static class Single
    extends ChemicalStackIngredient.SingleIngredient<Gas, GasStack>
    implements GasStackIngredient {
        protected Single(@Nonnull GasStack stack) {
            super(stack);
        }
    }
}

