/*
 * Decompiled with CFR 0.152.
 */
package com.qsoftware.modlib.api.recipes.inputs.chemical;

import com.qsoftware.modlib.api.chemical.Chemical;
import com.qsoftware.modlib.api.chemical.ChemicalStack;
import com.qsoftware.modlib.api.chemical.ChemicalTags;
import com.qsoftware.modlib.api.chemical.ChemicalUtils;
import com.qsoftware.modlib.api.chemical.IEmptyStackProvider;
import com.qsoftware.modlib.api.chemical.gas.Gas;
import com.qsoftware.modlib.api.chemical.gas.GasStack;
import com.qsoftware.modlib.api.chemical.infuse.InfuseType;
import com.qsoftware.modlib.api.chemical.infuse.InfusionStack;
import com.qsoftware.modlib.api.chemical.pigment.Pigment;
import com.qsoftware.modlib.api.chemical.pigment.PigmentStack;
import com.qsoftware.modlib.api.chemical.slurry.Slurry;
import com.qsoftware.modlib.api.chemical.slurry.SlurryStack;
import javax.annotation.Nonnull;
import net.minecraft.tags.ITag;
import net.minecraft.util.ResourceLocation;

class ChemicalIngredientInfo<CHEMICAL extends Chemical<CHEMICAL>, STACK extends ChemicalStack<CHEMICAL>>
implements IEmptyStackProvider<CHEMICAL, STACK> {
    public static final ChemicalIngredientInfo<Gas, GasStack> GAS = new ChemicalIngredientInfo<Gas, GasStack>(GasStack.EMPTY, GasStack::new, GasStack::new, "gas", ChemicalTags.GAS);
    public static final ChemicalIngredientInfo<InfuseType, InfusionStack> INFUSION = new ChemicalIngredientInfo<InfuseType, InfusionStack>(InfusionStack.EMPTY, InfusionStack::new, InfusionStack::new, "infuse_type", ChemicalTags.INFUSE_TYPE);
    public static final ChemicalIngredientInfo<Pigment, PigmentStack> PIGMENT = new ChemicalIngredientInfo<Pigment, PigmentStack>(PigmentStack.EMPTY, PigmentStack::new, PigmentStack::new, "pigment", ChemicalTags.PIGMENT);
    public static final ChemicalIngredientInfo<Slurry, SlurryStack> SLURRY = new ChemicalIngredientInfo<Slurry, SlurryStack>(SlurryStack.EMPTY, SlurryStack::new, SlurryStack::new, "slurry", ChemicalTags.SLURRY);
    private final ChemicalUtils.ChemicalToStackCreator<CHEMICAL, STACK> chemicalToStackCreator;
    private final ChemicalUtils.StackToStackCreator<STACK> stackToStackCreator;
    private final ChemicalTags<CHEMICAL> tags;
    private final String serializationKey;
    private final STACK emptyStack;

    private ChemicalIngredientInfo(STACK emptyStack, ChemicalUtils.ChemicalToStackCreator<CHEMICAL, STACK> chemicalToStackCreator, ChemicalUtils.StackToStackCreator<STACK> stackToStackCreator, String serializationKey, ChemicalTags<CHEMICAL> tags) {
        this.chemicalToStackCreator = chemicalToStackCreator;
        this.stackToStackCreator = stackToStackCreator;
        this.serializationKey = serializationKey;
        this.emptyStack = emptyStack;
        this.tags = tags;
    }

    public String getSerializationKey() {
        return this.serializationKey;
    }

    @Override
    @Nonnull
    public STACK getEmptyStack() {
        return this.emptyStack;
    }

    public STACK createStack(CHEMICAL chemical, long amount) {
        return this.chemicalToStackCreator.createStack(chemical, amount);
    }

    public STACK createStack(STACK stack, long amount) {
        return this.stackToStackCreator.createStack(stack, amount);
    }

    public ResourceLocation getTagLocation(ITag<CHEMICAL> tag) {
        return this.tags.lookupTag(tag);
    }
}

