/*
 * Decompiled with CFR 0.152.
 */
package com.qsoftware.modlib.api.recipes.inputs;

import com.qsoftware.modlib.api.Action;
import com.qsoftware.modlib.api.MekanismAPI;
import com.qsoftware.modlib.api.chemical.ChemicalType;
import com.qsoftware.modlib.api.chemical.gas.GasStack;
import com.qsoftware.modlib.api.chemical.infuse.InfusionStack;
import com.qsoftware.modlib.api.chemical.merged.BoxedChemicalStack;
import com.qsoftware.modlib.api.chemical.merged.MergedChemicalTank;
import com.qsoftware.modlib.api.chemical.pigment.PigmentStack;
import com.qsoftware.modlib.api.chemical.slurry.SlurryStack;
import com.qsoftware.modlib.api.math.MathUtils;
import com.qsoftware.modlib.api.recipes.inputs.chemical.GasStackIngredient;
import com.qsoftware.modlib.api.recipes.inputs.chemical.IChemicalStackIngredient;
import com.qsoftware.modlib.api.recipes.inputs.chemical.InfusionStackIngredient;
import com.qsoftware.modlib.api.recipes.inputs.chemical.PigmentStackIngredient;
import com.qsoftware.modlib.api.recipes.inputs.chemical.SlurryStackIngredient;
import java.util.Objects;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class BoxedChemicalInputHandler {
    private final MergedChemicalTank chemicalTank;

    public BoxedChemicalInputHandler(MergedChemicalTank chemicalTank) {
        this.chemicalTank = Objects.requireNonNull(chemicalTank);
    }

    private static void logMismatchedStackSize(long actual, long expected) {
        if (expected != actual) {
            MekanismAPI.logger.error("Stack size changed by a different amount ({}) than requested ({}).", (Object)actual, (Object)expected, (Object)new Exception());
        }
    }

    public BoxedChemicalStack getInput() {
        MergedChemicalTank.Current current = this.chemicalTank.getCurrent();
        if (current == MergedChemicalTank.Current.EMPTY) {
            return BoxedChemicalStack.EMPTY;
        }
        return BoxedChemicalStack.box(this.chemicalTank.getTankFromCurrent(current).getStack());
    }

    public BoxedChemicalStack getRecipeInput(IChemicalStackIngredient<?, ?> recipeIngredient) {
        BoxedChemicalStack input = this.getInput();
        if (input.isEmpty()) {
            return BoxedChemicalStack.EMPTY;
        }
        if (recipeIngredient instanceof GasStackIngredient) {
            if (input.getChemicalType() == ChemicalType.GAS) {
                return BoxedChemicalStack.box(((GasStackIngredient)recipeIngredient).getMatchingInstance((GasStack)input.getChemicalStack()));
            }
        } else if (recipeIngredient instanceof InfusionStackIngredient) {
            if (input.getChemicalType() == ChemicalType.INFUSION) {
                return BoxedChemicalStack.box(((InfusionStackIngredient)recipeIngredient).getMatchingInstance((InfusionStack)input.getChemicalStack()));
            }
        } else if (recipeIngredient instanceof PigmentStackIngredient) {
            if (input.getChemicalType() == ChemicalType.PIGMENT) {
                return BoxedChemicalStack.box(((PigmentStackIngredient)recipeIngredient).getMatchingInstance((PigmentStack)input.getChemicalStack()));
            }
        } else if (recipeIngredient instanceof SlurryStackIngredient) {
            if (input.getChemicalType() == ChemicalType.SLURRY) {
                return BoxedChemicalStack.box(((SlurryStackIngredient)recipeIngredient).getMatchingInstance((SlurryStack)input.getChemicalStack()));
            }
        } else {
            throw new IllegalStateException("Unknown Chemical Type");
        }
        return BoxedChemicalStack.EMPTY;
    }

    public void use(BoxedChemicalStack recipeInput, long operations) {
        if (operations == 0L) {
            return;
        }
        if (recipeInput.isEmpty()) {
            return;
        }
        BoxedChemicalStack inputGas = this.getInput();
        if (!inputGas.isEmpty()) {
            long amount = recipeInput.getChemicalStack().getAmount() * operations;
            BoxedChemicalInputHandler.logMismatchedStackSize(this.chemicalTank.getTankForType(inputGas.getChemicalType()).shrinkStack(amount, Action.EXECUTE), amount);
        }
    }

    public int operationsCanSupport(IChemicalStackIngredient<?, ?> recipeIngredient, int currentMax) {
        return this.operationsCanSupport(recipeIngredient, currentMax, 1L);
    }

    public int operationsCanSupport(IChemicalStackIngredient<?, ?> recipeIngredient, int currentMax, long usageMultiplier) {
        if (currentMax <= 0 || usageMultiplier == 0L) {
            return currentMax;
        }
        BoxedChemicalStack recipeInput = this.getRecipeInput(recipeIngredient);
        if (recipeInput.isEmpty()) {
            return 0;
        }
        return Math.min(MathUtils.clampToInt(this.getInput().getChemicalStack().getAmount() / (recipeInput.getChemicalStack().getAmount() * usageMultiplier)), currentMax);
    }
}

