/*
 * Decompiled with CFR 0.152.
 */
package com.qsoftware.modlib.api.recipes.chemical;

import com.qsoftware.modlib.api.annotations.FieldsAreNonnullByDefault;
import com.qsoftware.modlib.api.chemical.Chemical;
import com.qsoftware.modlib.api.chemical.ChemicalStack;
import com.qsoftware.modlib.api.recipes.MekanismRecipe;
import com.qsoftware.modlib.api.recipes.inputs.FluidStackIngredient;
import com.qsoftware.modlib.api.recipes.inputs.chemical.IChemicalStackIngredient;
import java.util.function.BiPredicate;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.Contract;

@FieldsAreNonnullByDefault
@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public abstract class FluidChemicalToChemicalRecipe<CHEMICAL extends Chemical<CHEMICAL>, STACK extends ChemicalStack<CHEMICAL>, INGREDIENT extends IChemicalStackIngredient<CHEMICAL, STACK>>
extends MekanismRecipe
implements BiPredicate<FluidStack, STACK> {
    protected final STACK output;
    private final FluidStackIngredient fluidInput;
    private final INGREDIENT chemicalInput;

    public FluidChemicalToChemicalRecipe(ResourceLocation id, FluidStackIngredient fluidInput, INGREDIENT chemicalInput, STACK output) {
        super(id);
        this.fluidInput = fluidInput;
        this.chemicalInput = chemicalInput;
        this.output = output;
    }

    @Override
    public boolean test(FluidStack fluidStack, STACK chemicalStack) {
        return this.fluidInput.test(fluidStack) && this.chemicalInput.test(chemicalStack);
    }

    public FluidStackIngredient getFluidInput() {
        return this.fluidInput;
    }

    public INGREDIENT getChemicalInput() {
        return this.chemicalInput;
    }

    public STACK getOutputRepresentation() {
        return this.output;
    }

    @Contract(value="_, _ -> new", pure=true)
    public abstract STACK getOutput(FluidStack var1, STACK var2);

    @Override
    public void write(PacketBuffer buffer) {
        this.fluidInput.write(buffer);
        this.chemicalInput.write(buffer);
        ((ChemicalStack)this.output).writeToPacket(buffer);
    }
}

