/*
 * Decompiled with CFR 0.152.
 */
package com.qsoftware.modlib.api.recipes.chemical;

import com.qsoftware.modlib.api.annotations.FieldsAreNonnullByDefault;
import com.qsoftware.modlib.api.chemical.Chemical;
import com.qsoftware.modlib.api.chemical.ChemicalStack;
import com.qsoftware.modlib.api.recipes.MekanismRecipe;
import com.qsoftware.modlib.api.recipes.inputs.chemical.IChemicalStackIngredient;
import java.util.function.Predicate;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import org.jetbrains.annotations.Contract;

@FieldsAreNonnullByDefault
@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public abstract class ChemicalToChemicalRecipe<CHEMICAL extends Chemical<CHEMICAL>, STACK extends ChemicalStack<CHEMICAL>, INGREDIENT extends IChemicalStackIngredient<CHEMICAL, STACK>>
extends MekanismRecipe
implements Predicate<STACK> {
    protected final STACK output;
    private final INGREDIENT input;

    public ChemicalToChemicalRecipe(ResourceLocation id, INGREDIENT input, STACK output) {
        super(id);
        this.input = input;
        this.output = output;
    }

    @Override
    public boolean test(STACK chemicalStack) {
        return this.input.test(chemicalStack);
    }

    public INGREDIENT getInput() {
        return this.input;
    }

    public STACK getOutputRepresentation() {
        return this.output;
    }

    @Contract(value="_ -> new", pure=true)
    public abstract STACK getOutput(STACK var1);

    @Override
    public void write(PacketBuffer buffer) {
        this.input.write(buffer);
        ((ChemicalStack)this.output).writeToPacket(buffer);
    }
}

