/*
 * Decompiled with CFR 0.152.
 */
package com.qsoftware.modlib.api.recipes.cache.chemical;

import com.qsoftware.modlib.api.annotations.FieldsAreNonnullByDefault;
import com.qsoftware.modlib.api.annotations.NonNull;
import com.qsoftware.modlib.api.chemical.Chemical;
import com.qsoftware.modlib.api.chemical.ChemicalStack;
import com.qsoftware.modlib.api.recipes.cache.CachedRecipe;
import com.qsoftware.modlib.api.recipes.chemical.ItemStackToChemicalRecipe;
import com.qsoftware.modlib.api.recipes.inputs.IInputHandler;
import com.qsoftware.modlib.api.recipes.outputs.IOutputHandler;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.item.ItemStack;

@FieldsAreNonnullByDefault
@ParametersAreNonnullByDefault
public class ItemStackToChemicalCachedRecipe<CHEMICAL extends Chemical<CHEMICAL>, STACK extends ChemicalStack<CHEMICAL>, RECIPE extends ItemStackToChemicalRecipe<CHEMICAL, STACK>>
extends CachedRecipe<RECIPE> {
    private final IOutputHandler<@NonNull STACK> outputHandler;
    private final IInputHandler<@NonNull ItemStack> inputHandler;

    public ItemStackToChemicalCachedRecipe(RECIPE recipe, IInputHandler<@NonNull ItemStack> inputHandler, IOutputHandler<@NonNull STACK> outputHandler) {
        super(recipe);
        this.inputHandler = inputHandler;
        this.outputHandler = outputHandler;
    }

    @Override
    protected int getOperationsThisTick(int currentMax) {
        if ((currentMax = super.getOperationsThisTick(currentMax)) <= 0) {
            return currentMax;
        }
        ItemStack recipeItem = this.inputHandler.getRecipeInput(((ItemStackToChemicalRecipe)this.recipe).getInput());
        if (recipeItem.func_190926_b()) {
            return -1;
        }
        currentMax = this.inputHandler.operationsCanSupport(((ItemStackToChemicalRecipe)this.recipe).getInput(), currentMax);
        if (currentMax <= 0) {
            return -1;
        }
        return this.outputHandler.operationsRoomFor(((ItemStackToChemicalRecipe)this.recipe).getOutput(recipeItem), currentMax);
    }

    @Override
    public boolean isInputValid() {
        return ((ItemStackToChemicalRecipe)this.recipe).test(this.inputHandler.getInput());
    }

    @Override
    protected void finishProcessing(int operations) {
        ItemStack recipeItem = this.inputHandler.getRecipeInput(((ItemStackToChemicalRecipe)this.recipe).getInput());
        if (recipeItem.func_190926_b()) {
            return;
        }
        this.inputHandler.use(recipeItem, operations);
        this.outputHandler.handleOutput(((ItemStackToChemicalRecipe)this.recipe).getOutput(recipeItem), operations);
    }
}

