/*
 * Decompiled with CFR 0.152.
 */
package com.qsoftware.modlib.api.recipes.cache.chemical;

import com.qsoftware.modlib.api.annotations.FieldsAreNonnullByDefault;
import com.qsoftware.modlib.api.annotations.NonNull;
import com.qsoftware.modlib.api.chemical.Chemical;
import com.qsoftware.modlib.api.chemical.ChemicalStack;
import com.qsoftware.modlib.api.recipes.cache.CachedRecipe;
import com.qsoftware.modlib.api.recipes.chemical.FluidChemicalToChemicalRecipe;
import com.qsoftware.modlib.api.recipes.inputs.IInputHandler;
import com.qsoftware.modlib.api.recipes.inputs.InputIngredient;
import com.qsoftware.modlib.api.recipes.inputs.chemical.IChemicalStackIngredient;
import com.qsoftware.modlib.api.recipes.outputs.IOutputHandler;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraftforge.fluids.FluidStack;

@FieldsAreNonnullByDefault
@ParametersAreNonnullByDefault
public class FluidChemicalToChemicalCachedRecipe<CHEMICAL extends Chemical<CHEMICAL>, STACK extends ChemicalStack<CHEMICAL>, INGREDIENT extends IChemicalStackIngredient<CHEMICAL, STACK>, RECIPE extends FluidChemicalToChemicalRecipe<CHEMICAL, STACK, INGREDIENT>>
extends CachedRecipe<RECIPE> {
    private final IOutputHandler<@NonNull STACK> outputHandler;
    private final IInputHandler<@NonNull FluidStack> fluidInputHandler;
    private final IInputHandler<@NonNull STACK> chemicalInputHandler;

    public FluidChemicalToChemicalCachedRecipe(RECIPE recipe, IInputHandler<@NonNull FluidStack> fluidInputHandler, IInputHandler<@NonNull STACK> chemicalInputHandler, IOutputHandler<@NonNull STACK> outputHandler) {
        super(recipe);
        this.fluidInputHandler = fluidInputHandler;
        this.chemicalInputHandler = chemicalInputHandler;
        this.outputHandler = outputHandler;
    }

    @Override
    protected int getOperationsThisTick(int currentMax) {
        if ((currentMax = super.getOperationsThisTick(currentMax)) <= 0) {
            return currentMax;
        }
        FluidStack recipeFluid = this.fluidInputHandler.getRecipeInput(((FluidChemicalToChemicalRecipe)this.recipe).getFluidInput());
        if (recipeFluid.isEmpty()) {
            return -1;
        }
        ChemicalStack recipeChemical = (ChemicalStack)this.chemicalInputHandler.getRecipeInput((InputIngredient<STACK>)((FluidChemicalToChemicalRecipe)this.recipe).getChemicalInput());
        if (recipeChemical.isEmpty()) {
            return -1;
        }
        currentMax = this.fluidInputHandler.operationsCanSupport(((FluidChemicalToChemicalRecipe)this.recipe).getFluidInput(), currentMax);
        currentMax = this.chemicalInputHandler.operationsCanSupport((InputIngredient<STACK>)((FluidChemicalToChemicalRecipe)this.recipe).getChemicalInput(), currentMax);
        if (currentMax <= 0) {
            return -1;
        }
        return this.outputHandler.operationsRoomFor(((FluidChemicalToChemicalRecipe)this.recipe).getOutput(recipeFluid, recipeChemical), currentMax);
    }

    @Override
    public boolean isInputValid() {
        FluidStack fluidStack = this.fluidInputHandler.getInput();
        if (fluidStack.isEmpty()) {
            return false;
        }
        ChemicalStack chemicalInput = (ChemicalStack)this.chemicalInputHandler.getInput();
        if (chemicalInput.isEmpty()) {
            return false;
        }
        return ((FluidChemicalToChemicalRecipe)this.recipe).test(fluidStack, chemicalInput);
    }

    @Override
    protected void finishProcessing(int operations) {
        FluidStack recipeFluid = this.fluidInputHandler.getRecipeInput(((FluidChemicalToChemicalRecipe)this.recipe).getFluidInput());
        if (recipeFluid.isEmpty()) {
            return;
        }
        ChemicalStack recipeChemical = (ChemicalStack)this.chemicalInputHandler.getRecipeInput((InputIngredient<STACK>)((FluidChemicalToChemicalRecipe)this.recipe).getChemicalInput());
        if (recipeChemical.isEmpty()) {
            return;
        }
        this.fluidInputHandler.use(recipeFluid, operations);
        this.chemicalInputHandler.use(recipeChemical, operations);
        this.outputHandler.handleOutput(((FluidChemicalToChemicalRecipe)this.recipe).getOutput(recipeFluid, recipeChemical), operations);
    }
}

