/*
 * Decompiled with CFR 0.152.
 */
package com.qsoftware.modlib.api.recipes.cache;

import com.qsoftware.modlib.api.annotations.FieldsAreNonnullByDefault;
import com.qsoftware.modlib.api.annotations.NonNull;
import com.qsoftware.modlib.api.recipes.SawmillRecipe;
import com.qsoftware.modlib.api.recipes.cache.CachedRecipe;
import com.qsoftware.modlib.api.recipes.inputs.IInputHandler;
import com.qsoftware.modlib.api.recipes.outputs.IOutputHandler;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.item.ItemStack;

@FieldsAreNonnullByDefault
@ParametersAreNonnullByDefault
public class SawmillCachedRecipe
extends CachedRecipe<SawmillRecipe> {
    private final IOutputHandler<@NonNull SawmillRecipe.ChanceOutput> outputHandler;
    private final IInputHandler<@NonNull ItemStack> inputHandler;

    public SawmillCachedRecipe(SawmillRecipe recipe, IInputHandler<@NonNull ItemStack> inputHandler, IOutputHandler<@NonNull SawmillRecipe.ChanceOutput> outputHandler) {
        super(recipe);
        this.inputHandler = inputHandler;
        this.outputHandler = outputHandler;
    }

    @Override
    protected int getOperationsThisTick(int currentMax) {
        if ((currentMax = super.getOperationsThisTick(currentMax)) <= 0) {
            return currentMax;
        }
        ItemStack recipeItem = this.inputHandler.getRecipeInput(((SawmillRecipe)this.recipe).getInput());
        if (recipeItem.func_190926_b()) {
            return -1;
        }
        currentMax = this.inputHandler.operationsCanSupport(((SawmillRecipe)this.recipe).getInput(), currentMax);
        if (currentMax <= 0) {
            return -1;
        }
        return this.outputHandler.operationsRoomFor(((SawmillRecipe)this.recipe).getOutput(recipeItem), currentMax);
    }

    @Override
    public boolean isInputValid() {
        return ((SawmillRecipe)this.recipe).test(this.inputHandler.getInput());
    }

    @Override
    protected void finishProcessing(int operations) {
        ItemStack recipeItem = this.inputHandler.getRecipeInput(((SawmillRecipe)this.recipe).getInput());
        if (recipeItem.func_190926_b()) {
            return;
        }
        this.inputHandler.use(recipeItem, operations);
        this.outputHandler.handleOutput(((SawmillRecipe)this.recipe).getOutput(recipeItem), operations);
    }
}

