/*
 * Decompiled with CFR 0.152.
 */
package com.qsoftware.modlib.api.recipes.cache;

import com.qsoftware.modlib.api.recipes.MekanismRecipe;
import com.qsoftware.modlib.api.recipes.cache.CachedRecipe;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public interface ICachedRecipeHolder<RECIPE extends MekanismRecipe> {
    @Nullable
    default public CachedRecipe<RECIPE> getUpdatedCache(int cacheIndex) {
        RECIPE recipe;
        CachedRecipe<RECIPE> currentCache = this.getCachedRecipe(cacheIndex);
        if (this.invalidateCache()) {
            currentCache = null;
        }
        if (!(currentCache != null && currentCache.isInputValid() || (recipe = this.getRecipe(cacheIndex)) == null)) {
            CachedRecipe<RECIPE> cached = this.createNewCachedRecipe(recipe, cacheIndex);
            if (currentCache == null || cached != null) {
                if (currentCache == null && cached != null) {
                    cached.loadSavedOperatingTicks(this.getSavedOperatingTicks(cacheIndex));
                }
                return cached;
            }
        }
        return currentCache;
    }

    default public int getSavedOperatingTicks(int cacheIndex) {
        return 0;
    }

    @Nullable
    public CachedRecipe<RECIPE> getCachedRecipe(int var1);

    @Nullable
    public RECIPE getRecipe(int var1);

    @Nullable
    public CachedRecipe<RECIPE> createNewCachedRecipe(@Nonnull RECIPE var1, int var2);

    default public boolean invalidateCache() {
        return false;
    }
}

