/*
 * Decompiled with CFR 0.152.
 */
package com.qsoftware.modlib.api.recipes.cache;

import com.qsoftware.modlib.api.annotations.FieldsAreNonnullByDefault;
import com.qsoftware.modlib.api.annotations.NonNull;
import com.qsoftware.modlib.api.recipes.FluidToFluidRecipe;
import com.qsoftware.modlib.api.recipes.cache.CachedRecipe;
import com.qsoftware.modlib.api.recipes.inputs.IInputHandler;
import com.qsoftware.modlib.api.recipes.outputs.IOutputHandler;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraftforge.fluids.FluidStack;

@FieldsAreNonnullByDefault
@ParametersAreNonnullByDefault
public class FluidToFluidCachedRecipe
extends CachedRecipe<FluidToFluidRecipe> {
    private final IOutputHandler<@NonNull FluidStack> outputHandler;
    private final IInputHandler<@NonNull FluidStack> inputHandler;

    public FluidToFluidCachedRecipe(FluidToFluidRecipe recipe, IInputHandler<@NonNull FluidStack> inputHandler, IOutputHandler<@NonNull FluidStack> outputHandler) {
        super(recipe);
        this.inputHandler = inputHandler;
        this.outputHandler = outputHandler;
    }

    @Override
    protected int getOperationsThisTick(int currentMax) {
        if ((currentMax = super.getOperationsThisTick(currentMax)) <= 0) {
            return currentMax;
        }
        FluidStack recipeFluid = this.inputHandler.getRecipeInput(((FluidToFluidRecipe)this.recipe).getInput());
        if (recipeFluid.isEmpty()) {
            return -1;
        }
        currentMax = this.inputHandler.operationsCanSupport(((FluidToFluidRecipe)this.recipe).getInput(), currentMax);
        if (currentMax <= 0) {
            return -1;
        }
        return this.outputHandler.operationsRoomFor(((FluidToFluidRecipe)this.recipe).getOutput(recipeFluid), currentMax);
    }

    @Override
    public boolean isInputValid() {
        return ((FluidToFluidRecipe)this.recipe).test(this.inputHandler.getInput());
    }

    @Override
    protected void finishProcessing(int operations) {
        FluidStack recipeFluid = this.inputHandler.getRecipeInput(((FluidToFluidRecipe)this.recipe).getInput());
        if (recipeFluid.isEmpty()) {
            return;
        }
        this.inputHandler.use(recipeFluid, operations);
        this.outputHandler.handleOutput(((FluidToFluidRecipe)this.recipe).getOutput(recipeFluid), operations);
    }
}

