/*
 * Decompiled with CFR 0.152.
 */
package com.qsoftware.modlib.api.recipes.cache;

import com.qsoftware.modlib.api.annotations.FieldsAreNonnullByDefault;
import com.qsoftware.modlib.api.annotations.NonNull;
import com.qsoftware.modlib.api.chemical.gas.GasStack;
import com.qsoftware.modlib.api.recipes.ElectrolysisRecipe;
import com.qsoftware.modlib.api.recipes.cache.CachedRecipe;
import com.qsoftware.modlib.api.recipes.inputs.IInputHandler;
import com.qsoftware.modlib.api.recipes.outputs.IOutputHandler;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraftforge.fluids.FluidStack;
import org.apache.commons.lang3.tuple.Pair;

@FieldsAreNonnullByDefault
@ParametersAreNonnullByDefault
public class ElectrolysisCachedRecipe
extends CachedRecipe<ElectrolysisRecipe> {
    private final IOutputHandler<@NonNull Pair<GasStack, GasStack>> outputHandler;
    private final IInputHandler<@NonNull FluidStack> inputHandler;

    public ElectrolysisCachedRecipe(ElectrolysisRecipe recipe, IInputHandler<@NonNull FluidStack> inputHandler, IOutputHandler<@NonNull Pair<GasStack, GasStack>> outputHandler) {
        super(recipe);
        this.inputHandler = inputHandler;
        this.outputHandler = outputHandler;
    }

    @Override
    protected int getOperationsThisTick(int currentMax) {
        if ((currentMax = super.getOperationsThisTick(currentMax)) <= 0) {
            return currentMax;
        }
        FluidStack recipeFluid = this.inputHandler.getRecipeInput(((ElectrolysisRecipe)this.recipe).getInput());
        if (recipeFluid.isEmpty()) {
            return -1;
        }
        currentMax = this.inputHandler.operationsCanSupport(((ElectrolysisRecipe)this.recipe).getInput(), currentMax);
        if (currentMax <= 0) {
            return -1;
        }
        return this.outputHandler.operationsRoomFor(((ElectrolysisRecipe)this.recipe).getOutput(recipeFluid), currentMax);
    }

    @Override
    public boolean isInputValid() {
        return ((ElectrolysisRecipe)this.recipe).test(this.inputHandler.getInput());
    }

    @Override
    protected void finishProcessing(int operations) {
        FluidStack recipeFluid = this.inputHandler.getRecipeInput(((ElectrolysisRecipe)this.recipe).getInput());
        if (recipeFluid.isEmpty()) {
            return;
        }
        this.inputHandler.use(recipeFluid, operations);
        this.outputHandler.handleOutput(((ElectrolysisRecipe)this.recipe).getOutput(recipeFluid), operations);
    }
}

