/*
 * Decompiled with CFR 0.152.
 */
package com.qsoftware.modlib.api.recipes.cache;

import com.qsoftware.modlib.api.annotations.FieldsAreNonnullByDefault;
import com.qsoftware.modlib.api.annotations.NonNull;
import com.qsoftware.modlib.api.chemical.gas.GasStack;
import com.qsoftware.modlib.api.recipes.ChemicalDissolutionRecipe;
import com.qsoftware.modlib.api.recipes.cache.CachedRecipe;
import com.qsoftware.modlib.api.recipes.inputs.IInputHandler;
import com.qsoftware.modlib.api.recipes.inputs.ILongInputHandler;
import com.qsoftware.modlib.api.recipes.inputs.InputIngredient;
import com.qsoftware.modlib.api.recipes.outputs.BoxedChemicalOutputHandler;
import java.util.function.LongSupplier;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.item.ItemStack;

@FieldsAreNonnullByDefault
@ParametersAreNonnullByDefault
public class ChemicalDissolutionCachedRecipe
extends CachedRecipe<ChemicalDissolutionRecipe> {
    private final BoxedChemicalOutputHandler outputHandler;
    private final IInputHandler<@NonNull ItemStack> itemInputHandler;
    private final ILongInputHandler<@NonNull GasStack> gasInputHandler;
    private final LongSupplier gasUsage;

    public ChemicalDissolutionCachedRecipe(ChemicalDissolutionRecipe recipe, IInputHandler<@NonNull ItemStack> itemInputHandler, ILongInputHandler<@NonNull GasStack> chemicalInputHandler, LongSupplier gasUsage, BoxedChemicalOutputHandler outputHandler) {
        super(recipe);
        this.itemInputHandler = itemInputHandler;
        this.gasInputHandler = chemicalInputHandler;
        this.gasUsage = gasUsage;
        this.outputHandler = outputHandler;
    }

    private long getGasUsage() {
        return this.gasUsage.getAsLong();
    }

    @Override
    protected int getOperationsThisTick(int currentMax) {
        if ((currentMax = super.getOperationsThisTick(currentMax)) <= 0) {
            return currentMax;
        }
        ItemStack recipeItem = this.itemInputHandler.getRecipeInput(((ChemicalDissolutionRecipe)this.recipe).getItemInput());
        if (recipeItem.func_190926_b()) {
            return -1;
        }
        GasStack recipeGas = this.gasInputHandler.getRecipeInput(((ChemicalDissolutionRecipe)this.recipe).getGasInput());
        if (recipeGas.isEmpty()) {
            return 0;
        }
        currentMax = this.itemInputHandler.operationsCanSupport(((ChemicalDissolutionRecipe)this.recipe).getItemInput(), currentMax);
        if (currentMax <= 0) {
            return -1;
        }
        currentMax = this.gasInputHandler.operationsCanSupport((InputIngredient<GasStack>)((ChemicalDissolutionRecipe)this.recipe).getGasInput(), currentMax, this.getGasUsage());
        return this.outputHandler.operationsRoomFor(((ChemicalDissolutionRecipe)this.recipe).getOutput(recipeItem, recipeGas), currentMax);
    }

    @Override
    public boolean isInputValid() {
        GasStack gasStack = (GasStack)this.gasInputHandler.getInput();
        if (!gasStack.isEmpty() && ((ChemicalDissolutionRecipe)this.recipe).test(this.itemInputHandler.getInput(), gasStack)) {
            GasStack recipeGas = this.gasInputHandler.getRecipeInput(((ChemicalDissolutionRecipe)this.recipe).getGasInput());
            return !recipeGas.isEmpty() && gasStack.getAmount() >= recipeGas.getAmount();
        }
        return false;
    }

    @Override
    protected void useResources(int operations) {
        super.useResources(operations);
        GasStack recipeGas = this.gasInputHandler.getRecipeInput(((ChemicalDissolutionRecipe)this.recipe).getGasInput());
        if (recipeGas.isEmpty()) {
            return;
        }
        this.gasInputHandler.use(recipeGas, (long)operations * this.getGasUsage());
    }

    @Override
    protected void finishProcessing(int operations) {
        ItemStack recipeItem = this.itemInputHandler.getRecipeInput(((ChemicalDissolutionRecipe)this.recipe).getItemInput());
        if (recipeItem.func_190926_b()) {
            return;
        }
        GasStack recipeGas = this.gasInputHandler.getRecipeInput(((ChemicalDissolutionRecipe)this.recipe).getGasInput());
        if (recipeGas.isEmpty()) {
            return;
        }
        this.itemInputHandler.use(recipeItem, operations);
        this.gasInputHandler.use(recipeGas, operations);
        this.outputHandler.handleOutput(((ChemicalDissolutionRecipe)this.recipe).getOutput(recipeItem, recipeGas), operations);
    }
}

