/*
 * Decompiled with CFR 0.152.
 */
package com.qsoftware.modlib.api.recipes.cache;

import com.qsoftware.modlib.api.annotations.FieldsAreNonnullByDefault;
import com.qsoftware.modlib.api.annotations.NonNull;
import com.qsoftware.modlib.api.chemical.merged.BoxedChemicalStack;
import com.qsoftware.modlib.api.recipes.ChemicalCrystallizerRecipe;
import com.qsoftware.modlib.api.recipes.cache.CachedRecipe;
import com.qsoftware.modlib.api.recipes.inputs.BoxedChemicalInputHandler;
import com.qsoftware.modlib.api.recipes.outputs.IOutputHandler;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.item.ItemStack;

@FieldsAreNonnullByDefault
@ParametersAreNonnullByDefault
public class ChemicalCrystallizerCachedRecipe
extends CachedRecipe<ChemicalCrystallizerRecipe> {
    private final IOutputHandler<@NonNull ItemStack> outputHandler;
    private final BoxedChemicalInputHandler inputHandler;

    public ChemicalCrystallizerCachedRecipe(ChemicalCrystallizerRecipe recipe, BoxedChemicalInputHandler inputHandler, IOutputHandler<@NonNull ItemStack> outputHandler) {
        super(recipe);
        this.inputHandler = inputHandler;
        this.outputHandler = outputHandler;
    }

    @Override
    protected int getOperationsThisTick(int currentMax) {
        if ((currentMax = super.getOperationsThisTick(currentMax)) <= 0) {
            return currentMax;
        }
        BoxedChemicalStack recipeInput = this.inputHandler.getRecipeInput(((ChemicalCrystallizerRecipe)this.recipe).getInput());
        if (recipeInput.isEmpty()) {
            return -1;
        }
        currentMax = this.inputHandler.operationsCanSupport(((ChemicalCrystallizerRecipe)this.recipe).getInput(), currentMax);
        if (currentMax <= 0) {
            return -1;
        }
        return this.outputHandler.operationsRoomFor(((ChemicalCrystallizerRecipe)this.recipe).getOutput(recipeInput), currentMax);
    }

    @Override
    public boolean isInputValid() {
        return ((ChemicalCrystallizerRecipe)this.recipe).test(this.inputHandler.getInput());
    }

    @Override
    protected void finishProcessing(int operations) {
        BoxedChemicalStack recipeInput = this.inputHandler.getRecipeInput(((ChemicalCrystallizerRecipe)this.recipe).getInput());
        if (recipeInput.isEmpty()) {
            return;
        }
        this.inputHandler.use(recipeInput, operations);
        this.outputHandler.handleOutput(((ChemicalCrystallizerRecipe)this.recipe).getOutput(recipeInput), operations);
    }
}

