/*
 * Decompiled with CFR 0.152.
 */
package com.qsoftware.modlib.api.recipes;

import com.qsoftware.modlib.api.annotations.FieldsAreNonnullByDefault;
import com.qsoftware.modlib.api.math.FloatingLong;
import com.qsoftware.modlib.api.recipes.MekanismRecipe;
import com.qsoftware.modlib.api.recipes.inputs.ItemStackIngredient;
import java.util.function.Predicate;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;

@FieldsAreNonnullByDefault
@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public abstract class ItemStackToEnergyRecipe
extends MekanismRecipe
implements Predicate<ItemStack> {
    protected final ItemStackIngredient input;
    protected final FloatingLong output;

    public ItemStackToEnergyRecipe(ResourceLocation id, ItemStackIngredient input, FloatingLong output) {
        super(id);
        this.input = input;
        this.output = output.copyAsConst();
    }

    @Override
    public boolean test(ItemStack itemStack) {
        return this.input.test(itemStack);
    }

    public ItemStackIngredient getInput() {
        return this.input;
    }

    public FloatingLong getOutput(ItemStack input) {
        return this.output;
    }

    public FloatingLong getOutputDefinition() {
        return this.output;
    }

    @Override
    public void write(PacketBuffer buffer) {
        this.input.write(buffer);
        this.output.writeToBuffer(buffer);
    }
}

