/*
 * Decompiled with CFR 0.152.
 */
package com.qsoftware.modlib.api.recipes;

import com.qsoftware.modlib.api.annotations.FieldsAreNonnullByDefault;
import com.qsoftware.modlib.api.recipes.MekanismRecipe;
import com.qsoftware.modlib.api.recipes.inputs.FluidStackIngredient;
import java.util.function.Predicate;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.Contract;

@FieldsAreNonnullByDefault
@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public abstract class FluidToFluidRecipe
extends MekanismRecipe
implements Predicate<FluidStack> {
    private final FluidStackIngredient input;
    private final FluidStack output;

    public FluidToFluidRecipe(ResourceLocation id, FluidStackIngredient input, FluidStack output) {
        super(id);
        this.input = input;
        this.output = output;
    }

    @Override
    public boolean test(FluidStack fluidStack) {
        return this.input.test(fluidStack);
    }

    public FluidStackIngredient getInput() {
        return this.input;
    }

    public FluidStack getOutputRepresentation() {
        return this.output;
    }

    @Contract(value="_->new", pure=true)
    public FluidStack getOutput(FluidStack input) {
        return this.output.copy();
    }

    @Override
    public void write(PacketBuffer buffer) {
        this.input.write(buffer);
        this.output.writeToPacket(buffer);
    }
}

