/*
 * Decompiled with CFR 0.152.
 */
package com.qsoftware.modlib.api.recipes;

import com.qsoftware.modlib.api.annotations.FieldsAreNonnullByDefault;
import com.qsoftware.modlib.api.chemical.gas.GasStack;
import com.qsoftware.modlib.api.recipes.MekanismRecipe;
import com.qsoftware.modlib.api.recipes.inputs.chemical.GasStackIngredient;
import java.util.Collections;
import java.util.List;
import java.util.function.BiPredicate;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import org.jetbrains.annotations.Contract;

@FieldsAreNonnullByDefault
@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public abstract class ChemicalInfuserRecipe
extends MekanismRecipe
implements BiPredicate<GasStack, GasStack> {
    private final GasStackIngredient leftInput;
    private final GasStackIngredient rightInput;
    private final GasStack output;

    public ChemicalInfuserRecipe(ResourceLocation id, GasStackIngredient leftInput, GasStackIngredient rightInput, GasStack output) {
        super(id);
        this.leftInput = leftInput;
        this.rightInput = rightInput;
        this.output = output;
    }

    @Override
    public boolean test(GasStack input1, GasStack input2) {
        return this.leftInput.test(input1) && this.rightInput.test(input2) || this.rightInput.test(input1) && this.leftInput.test(input2);
    }

    @Contract(value="_, _ -> new", pure=true)
    public GasStack getOutput(GasStack input1, GasStack input2) {
        return this.output.copy();
    }

    public GasStackIngredient getLeftInput() {
        return this.leftInput;
    }

    public GasStackIngredient getRightInput() {
        return this.rightInput;
    }

    public List<GasStack> getOutputDefinition() {
        return Collections.singletonList(this.output);
    }

    @Override
    public void write(PacketBuffer buffer) {
        this.leftInput.write(buffer);
        this.rightInput.write(buffer);
        this.output.writeToPacket(buffer);
    }
}

