/*
 * Decompiled with CFR 0.152.
 */
package com.qsoftware.modlib.api.math;

import com.qsoftware.modlib.api.math.MathUtils;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import java.util.Objects;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.network.PacketBuffer;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class FloatingLong
extends Number
implements Comparable<FloatingLong> {
    public static final FloatingLong ZERO = FloatingLong.createConst(0L);
    public static final FloatingLong ONE = FloatingLong.createConst(1L);
    private static final DecimalFormat df;
    private static final int DECIMAL_DIGITS = 4;
    private static final short MAX_DECIMAL = 9999;
    public static final FloatingLong MAX_VALUE;
    private static final short SINGLE_UNIT = 10000;
    private static final double MAX_AS_DOUBLE;
    private final boolean isConstant;
    private long value;
    private short decimal;

    private FloatingLong(long value, short decimal, boolean isConstant) {
        this.setAndClampValues(value, decimal);
        this.isConstant = isConstant;
    }

    public static FloatingLong create(double value) {
        if (value > MAX_AS_DOUBLE) {
            return MAX_VALUE;
        }
        if (value < 0.0) {
            return ZERO;
        }
        long lValue = (long)value;
        short decimal = FloatingLong.parseDecimal(df.format(value));
        return FloatingLong.create(lValue, decimal);
    }

    public static FloatingLong create(long value) {
        return FloatingLong.create(value, (short)0);
    }

    public static FloatingLong create(long value, short decimal) {
        return new FloatingLong(value, decimal, false);
    }

    public static FloatingLong createConst(double value) {
        if (value > MAX_AS_DOUBLE) {
            return MAX_VALUE;
        }
        if (value < 0.0) {
            return ZERO;
        }
        long lValue = (long)value;
        short decimal = FloatingLong.parseDecimal(df.format(value));
        return FloatingLong.createConst(lValue, decimal);
    }

    public static FloatingLong createConst(long value) {
        return FloatingLong.createConst(value, (short)0);
    }

    public static FloatingLong createConst(long value, short decimal) {
        return new FloatingLong(value, decimal, true);
    }

    public static FloatingLong readFromBuffer(PacketBuffer buffer) {
        return new FloatingLong(buffer.func_179260_f(), buffer.readShort(), false);
    }

    public static FloatingLong parseFloatingLong(String string) {
        return FloatingLong.parseFloatingLong(string, false);
    }

    public static FloatingLong parseFloatingLong(String string, boolean isConstant) {
        int index = string.indexOf(".");
        long value = index == -1 ? Long.parseUnsignedLong(string) : Long.parseUnsignedLong(string.substring(0, index));
        short decimal = FloatingLong.parseDecimal(string, index);
        return isConstant ? FloatingLong.createConst(value, decimal) : FloatingLong.create(value, decimal);
    }

    private static short parseDecimal(String string) {
        return FloatingLong.parseDecimal(string, string.indexOf("."));
    }

    private static short parseDecimal(String string, int index) {
        if (index == -1) {
            return 0;
        }
        String decimalAsString = string.substring(index + 1);
        int numberDigits = decimalAsString.length();
        if (numberDigits < 4) {
            decimalAsString = decimalAsString + FloatingLong.getZeros(4 - numberDigits);
        } else if (numberDigits > 4) {
            decimalAsString = decimalAsString.substring(0, 4);
        }
        return Short.parseShort(decimalAsString);
    }

    private static String getZeros(int number) {
        StringBuilder zeros = new StringBuilder();
        for (int i = 0; i < number; ++i) {
            zeros.append('0');
        }
        return zeros.toString();
    }

    private static boolean multiplyLongsWillOverFlow(long a, long b) {
        return a != 0L && b != 0L && Long.compareUnsigned(b, Long.divideUnsigned(-1L, a)) > 0;
    }

    private static long multiplyLongs(long a, long b) {
        if (a == 0L || b == 0L) {
            return 0L;
        }
        if (FloatingLong.multiplyLongsWillOverFlow(a, b)) {
            return -1L;
        }
        return a * b;
    }

    private static FloatingLong multiplyLongAndDecimal(long value, short decimal) {
        if (Long.compareUnsigned(value, Long.divideUnsigned(-1L, 10000L)) > 0) {
            return FloatingLong.create(Long.divideUnsigned(value, 10000L) * (long)decimal, (short)(value % 10000L * (long)decimal));
        }
        return FloatingLong.create(Long.divideUnsigned(value * (long)decimal, 10000L), (short)(value * (long)decimal % 10000L));
    }

    private static FloatingLong multiplyDecimals(short a, short b) {
        long temp = (long)a * (long)b / 10000L;
        return FloatingLong.create(0L, (short)temp);
    }

    public long getValue() {
        return this.value;
    }

    public short getDecimal() {
        return this.decimal;
    }

    private FloatingLong setAndClampValues(long value, short decimal) {
        if (decimal < 0) {
            decimal = 0;
        } else if (decimal > 9999) {
            decimal = (short)9999;
        }
        if (this.isConstant) {
            return FloatingLong.create(value, decimal);
        }
        this.value = value;
        this.decimal = decimal;
        return this;
    }

    public boolean isZero() {
        return this.value == 0L && this.decimal <= 0;
    }

    public FloatingLong copy() {
        return new FloatingLong(this.value, this.decimal, false);
    }

    public FloatingLong copyAsConst() {
        return this.isConstant ? this : new FloatingLong(this.value, this.decimal, true);
    }

    public FloatingLong plusEqual(FloatingLong toAdd) {
        if (this.value < 0L && toAdd.value < 0L || (this.value < 0L || toAdd.value < 0L) && this.value + toAdd.value >= 0L) {
            return this.setAndClampValues(-1L, (short)9999);
        }
        long newValue = this.value + toAdd.value;
        int newDecimal = this.decimal + toAdd.decimal;
        if (newDecimal > 9999) {
            if (newValue == -1L) {
                newDecimal = 9999;
            } else {
                newDecimal = (short)(newDecimal - 10000);
                ++newValue;
            }
        }
        return this.setAndClampValues(newValue, (short)newDecimal);
    }

    public FloatingLong minusEqual(FloatingLong toSubtract) {
        if (toSubtract.greaterThan(this)) {
            return this.setAndClampValues(0L, (short)0);
        }
        long newValue = this.value - toSubtract.value;
        short newDecimal = (short)(this.decimal - toSubtract.decimal);
        if (newDecimal < 0) {
            newDecimal = (short)(newDecimal + 10000);
            --newValue;
        }
        return this.setAndClampValues(newValue, newDecimal);
    }

    public FloatingLong timesEqual(FloatingLong toMultiply) {
        if (FloatingLong.multiplyLongsWillOverFlow(this.value, toMultiply.value)) {
            return MAX_VALUE;
        }
        FloatingLong temp = FloatingLong.create(FloatingLong.multiplyLongs(this.value, toMultiply.value));
        temp = temp.plusEqual(FloatingLong.multiplyLongAndDecimal(this.value, toMultiply.decimal));
        temp = temp.plusEqual(FloatingLong.multiplyLongAndDecimal(toMultiply.value, this.decimal));
        temp = temp.plusEqual(FloatingLong.multiplyDecimals(this.decimal, toMultiply.decimal));
        return this.setAndClampValues(temp.value, temp.decimal);
    }

    public FloatingLong divideEquals(FloatingLong toDivide) {
        if (toDivide.isZero()) {
            throw new ArithmeticException("Division by zero");
        }
        BigDecimal divide = new BigDecimal(this.toString()).divide(new BigDecimal(toDivide.toString()), 4, RoundingMode.HALF_EVEN);
        long value = divide.longValue();
        short decimal = FloatingLong.parseDecimal(divide.toPlainString());
        return this.setAndClampValues(value, decimal);
    }

    public FloatingLong add(FloatingLong toAdd) {
        return this.copy().plusEqual(toAdd);
    }

    public FloatingLong add(long toAdd) {
        return this.add(FloatingLong.create(toAdd));
    }

    public FloatingLong add(double toAdd) {
        if (toAdd < 0.0) {
            throw new IllegalArgumentException("Addition called with negative number, this is not supported. FloatingLongs are always positive.");
        }
        return this.add(FloatingLong.create(toAdd));
    }

    public FloatingLong subtract(FloatingLong toSubtract) {
        return this.copy().minusEqual(toSubtract);
    }

    public FloatingLong subtract(long toSubtract) {
        return this.subtract(FloatingLong.create(toSubtract));
    }

    public FloatingLong subtract(double toSubtract) {
        if (toSubtract < 0.0) {
            throw new IllegalArgumentException("Subtraction called with negative number, this is not supported. FloatingLongs are always positive.");
        }
        return this.subtract(FloatingLong.create(toSubtract));
    }

    public FloatingLong multiply(FloatingLong toMultiply) {
        return this.copy().timesEqual(toMultiply);
    }

    public FloatingLong multiply(long toMultiply) {
        return this.multiply(FloatingLong.create(toMultiply));
    }

    public FloatingLong multiply(double toMultiply) {
        if (toMultiply < 0.0) {
            throw new IllegalArgumentException("Multiply called with negative number, this is not supported. FloatingLongs are always positive.");
        }
        return this.multiply(FloatingLong.createConst(toMultiply));
    }

    public FloatingLong divide(FloatingLong toDivide) {
        return this.copy().divideEquals(toDivide);
    }

    public FloatingLong divide(long toDivide) {
        return this.divide(FloatingLong.create(toDivide));
    }

    public FloatingLong divide(double toDivide) {
        if (toDivide < 0.0) {
            throw new IllegalArgumentException("Division called with negative number, this is not supported. FloatingLongs are always positive.");
        }
        return this.divide(FloatingLong.create(toDivide));
    }

    public double divideToLevel(FloatingLong toDivide) {
        return toDivide.isZero() || this.greaterThan(toDivide) ? 1.0 : this.divide(toDivide).doubleValue();
    }

    public FloatingLong max(FloatingLong other) {
        return this.smallerThan(other) ? other : this;
    }

    public FloatingLong min(FloatingLong other) {
        return this.greaterThan(other) ? other : this;
    }

    public FloatingLong ceil() {
        if (this.decimal == 0) {
            return this;
        }
        if (this.value == -1L) {
            return new FloatingLong(this.value, 0, false);
        }
        return new FloatingLong(this.value + 1L, 0, false);
    }

    public FloatingLong floor() {
        return this.decimal == 0 ? this : new FloatingLong(this.value, 0, false);
    }

    public boolean smallerThan(FloatingLong toCompare) {
        return this.compareTo(toCompare) < 0;
    }

    public boolean smallerOrEqual(FloatingLong toCompare) {
        return this.compareTo(toCompare) <= 0;
    }

    public boolean greaterThan(FloatingLong toCompare) {
        return this.compareTo(toCompare) > 0;
    }

    public boolean greaterOrEqual(FloatingLong toCompare) {
        return this.compareTo(toCompare) >= 0;
    }

    @Override
    public int compareTo(FloatingLong toCompare) {
        int valueCompare = Long.compareUnsigned(this.value, toCompare.value);
        if (valueCompare == 0) {
            if (this.decimal < toCompare.decimal) {
                return -2;
            }
            if (this.decimal > toCompare.decimal) {
                return 2;
            }
            return 0;
        }
        return valueCompare;
    }

    public boolean equals(FloatingLong other) {
        return this.value == other.value && this.decimal == other.decimal;
    }

    public boolean equals(Object other) {
        return this == other || other instanceof FloatingLong && this.equals((FloatingLong)other);
    }

    public int hashCode() {
        return Objects.hash(this.value, this.decimal);
    }

    @Override
    public int intValue() {
        return MathUtils.clampUnsignedToInt(this.value);
    }

    @Override
    public long longValue() {
        return MathUtils.clampUnsignedToLong(this.value);
    }

    @Override
    public float floatValue() {
        return MathUtils.unsignedLongToFloat(this.value) + (float)this.decimal / 10000.0f;
    }

    @Override
    public double doubleValue() {
        return MathUtils.unsignedLongToDouble(this.value) + (double)this.decimal / 10000.0;
    }

    public FloatingLong absDifference(FloatingLong other) {
        if (this.greaterThan(other)) {
            return this.subtract(other);
        }
        return this.add(other);
    }

    public void writeToBuffer(PacketBuffer buffer) {
        buffer.func_179254_b(this.value);
        buffer.writeShort((int)this.decimal);
    }

    public String toString() {
        return this.toString(4);
    }

    public String toString(int decimalPlaces) {
        if (this.decimal == 0) {
            return Long.toUnsignedString(this.value);
        }
        if (decimalPlaces > 4) {
            decimalPlaces = 4;
        }
        String valueAsString = Long.toUnsignedString(this.value) + ".";
        String decimalAsString = Short.toString(this.decimal);
        int numberDigits = decimalAsString.length();
        if (numberDigits < 4) {
            decimalAsString = FloatingLong.getZeros(4 - numberDigits) + decimalAsString;
            numberDigits = 4;
        }
        if (numberDigits > decimalPlaces) {
            decimalAsString = decimalAsString.substring(0, decimalPlaces);
        }
        return valueAsString + decimalAsString;
    }

    static {
        MAX_VALUE = FloatingLong.createConst(-1L, (short)9999);
        MAX_AS_DOUBLE = Double.parseDouble(MAX_VALUE.toString());
        df = new DecimalFormat("0.0000", DecimalFormatSymbols.getInstance(Locale.ENGLISH));
    }
}

