/*
 * Decompiled with CFR 0.152.
 */
package com.qsoftware.modlib.api.heat;

import com.qsoftware.modlib.api.heat.IHeatHandler;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.util.Direction;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public interface ISidedHeatHandler
extends IHeatHandler {
    @Nullable
    default public Direction getHeatSideFor() {
        return null;
    }

    public int getHeatCapacitorCount(@Nullable Direction var1);

    @Override
    default public int getHeatCapacitorCount() {
        return this.getHeatCapacitorCount(this.getHeatSideFor());
    }

    public double getTemperature(int var1, @Nullable Direction var2);

    @Override
    default public double getTemperature(int capacitor) {
        return this.getTemperature(capacitor, this.getHeatSideFor());
    }

    public double getInverseConduction(int var1, @Nullable Direction var2);

    @Override
    default public double getInverseConduction(int capacitor) {
        return this.getInverseConduction(capacitor, this.getHeatSideFor());
    }

    public double getHeatCapacity(int var1, @Nullable Direction var2);

    @Override
    default public double getHeatCapacity(int capacitor) {
        return this.getHeatCapacity(capacitor, this.getHeatSideFor());
    }

    public void handleHeat(int var1, double var2, @Nullable Direction var4);

    @Override
    default public void handleHeat(int capacitor, double transfer) {
        this.handleHeat(capacitor, transfer, this.getHeatSideFor());
    }

    default public double getTotalTemperature(@Nullable Direction side) {
        int heatCapacitorCount = this.getHeatCapacitorCount(side);
        if (heatCapacitorCount == 1) {
            return this.getTemperature(0, side);
        }
        double sum = 0.0;
        double totalCapacity = this.getTotalHeatCapacity(side);
        for (int capacitor = 0; capacitor < heatCapacitorCount; ++capacitor) {
            sum += this.getTemperature(capacitor, side) * (this.getHeatCapacity(capacitor, side) / totalCapacity);
        }
        return sum;
    }

    default public double getTotalInverseConductionCoefficient(@Nullable Direction side) {
        int heatCapacitorCount = this.getHeatCapacitorCount(side);
        if (heatCapacitorCount == 0) {
            return 1.0;
        }
        if (heatCapacitorCount == 1) {
            return this.getInverseConduction(0, side);
        }
        double sum = 0.0;
        double totalCapacity = this.getTotalHeatCapacity(side);
        for (int capacitor = 0; capacitor < heatCapacitorCount; ++capacitor) {
            sum += this.getInverseConduction(capacitor, side) * (this.getHeatCapacity(capacitor, side) / totalCapacity);
        }
        return sum;
    }

    default public double getTotalHeatCapacity(@Nullable Direction side) {
        int heatCapacitorCount = this.getHeatCapacitorCount(side);
        if (heatCapacitorCount == 1) {
            return this.getHeatCapacity(0, side);
        }
        double sum = 0.0;
        for (int capacitor = 0; capacitor < heatCapacitorCount; ++capacitor) {
            sum += this.getHeatCapacity(capacitor, side);
        }
        return sum;
    }

    default public void handleHeat(double transfer, @Nullable Direction side) {
        int heatCapacitorCount = this.getHeatCapacitorCount(side);
        if (heatCapacitorCount == 1) {
            this.handleHeat(0, transfer, side);
        } else {
            double totalHeatCapacity = this.getTotalHeatCapacity(side);
            for (int capacitor = 0; capacitor < heatCapacitorCount; ++capacitor) {
                this.handleHeat(capacitor, transfer * (this.getHeatCapacity(capacitor, side) / totalHeatCapacity), side);
            }
        }
    }
}

