/*
 * Decompiled with CFR 0.152.
 */
package com.qsoftware.modlib.api.fluid;

import com.qsoftware.modlib.api.Action;
import com.qsoftware.modlib.api.IContentsListener;
import com.qsoftware.modlib.api.fluid.IExtendedFluidTank;
import com.qsoftware.modlib.api.fluid.ISidedFluidHandler;
import com.qsoftware.modlib.api.inventory.AutomationType;
import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.util.Direction;
import net.minecraftforge.fluids.FluidStack;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public interface IMekanismFluidHandler
extends ISidedFluidHandler,
IContentsListener {
    default public boolean canHandleFluid() {
        return true;
    }

    public List<IExtendedFluidTank> getFluidTanks(@Nullable Direction var1);

    @Nullable
    default public IExtendedFluidTank getFluidTank(int tank, @Nullable Direction side) {
        List<IExtendedFluidTank> tanks = this.getFluidTanks(side);
        return tank >= 0 && tank < tanks.size() ? tanks.get(tank) : null;
    }

    @Override
    default public int getTanks(@Nullable Direction side) {
        return this.getFluidTanks(side).size();
    }

    @Override
    default public FluidStack getFluidInTank(int tank, @Nullable Direction side) {
        IExtendedFluidTank fluidTank = this.getFluidTank(tank, side);
        return fluidTank == null ? FluidStack.EMPTY : fluidTank.getFluid();
    }

    @Override
    default public void setFluidInTank(int tank, FluidStack stack, @Nullable Direction side) {
        IExtendedFluidTank fluidTank = this.getFluidTank(tank, side);
        if (fluidTank != null) {
            fluidTank.setStack(stack);
        }
    }

    @Override
    default public int getTankCapacity(int tank, @Nullable Direction side) {
        IExtendedFluidTank fluidTank = this.getFluidTank(tank, side);
        return fluidTank == null ? 0 : fluidTank.getCapacity();
    }

    @Override
    default public boolean isFluidValid(int tank, FluidStack stack, @Nullable Direction side) {
        IExtendedFluidTank fluidTank = this.getFluidTank(tank, side);
        return fluidTank != null && fluidTank.isFluidValid(stack);
    }

    @Override
    default public FluidStack insertFluid(int tank, FluidStack stack, @Nullable Direction side, Action action) {
        IExtendedFluidTank fluidTank = this.getFluidTank(tank, side);
        return fluidTank == null ? stack : fluidTank.insert(stack, action, side == null ? AutomationType.INTERNAL : AutomationType.EXTERNAL);
    }

    @Override
    default public FluidStack extractFluid(int tank, int amount, @Nullable Direction side, Action action) {
        IExtendedFluidTank fluidTank = this.getFluidTank(tank, side);
        return fluidTank == null ? FluidStack.EMPTY : fluidTank.extract(amount, action, side == null ? AutomationType.INTERNAL : AutomationType.EXTERNAL);
    }
}

